package edu.minilive.wedu.module.SO;

import lombok.Data;

/**
 * 视频转换参数
 * <p>
 * ffmpeg -threads 4 -i INPUT 
 * -r 29.97 
 * -vcodec libx264 
 * -s 480x272 
 * -flags +loop 
 * -cmp +chroma 
 * -deblockalpha 0 
 * -deblockbeta 0 
 * -crf 24
 * -bt 256k 
 * -refs 1 
 * -coder 0 
 * -me umh 
 * -me_range 16 
 * -subq 5
 * -partitions +parti4x4+parti8x8+partp8x8 
 * -g 250 
 * -keyint_min 25 
 * -level 30
 * -qmin 10 
 * -qmax 51 
 * -trellis 2 
 * -sc_threshold 40 
 * -i_qfactor 0.71 
 * -acodec libfaac 
 * -ab 128k 
 * -ar 48000 
 * -ac 2 
 * -vprofile high 
 * -preset slow 
 *  -b %bit% 
 *  -maxrate %bit% 
 *  -bufsize 800k  
 *  -f mp4 
 * OUTPUT
 * 
 * </p>
 * @author Janny create 2012-05-04
 */
public @Data class VideoConvertParamersSO {
	/**-i INPUT**/
	private String INPUT = null;
	/**-threads 4**/
	private String threads;
	/**-me umh**/
	private String me;
	/**-me_range 16**/
	private String me_range;
	//-subq 5
	private String subq;
	//-r 29.97
	private String r;
	//-vcodec libx264 
	private String vcodec;
	/**-s %wh%  480x272**/
	private String toHeight;
	//-flags +loop 
	private String flags;
	//-cmp +chroma 
	private String cmp;
	//* -deblockalpha 0
	private String deblockalpha;
	// * -deblockbeta 0 
	private String deblockbeta;
	// * -crf 24
	private String crf;
	//* -bt 256k 
	private String bt;
	// * -refs 1
	private String refs;
	// * -coder 0
	private String coder;
	// * -partitions +parti4x4+parti8x8+partp8x8
	private String partitions;
	// * -g 250
	private String g;
	// * -keyint_min 25 
	private String keyint_min;
	 //* -level 30
	private String level;
	 //* -qmin 10
	private String qmin;
	// * -qmax 51
	private String qmax;
	 //* -trellis 2
	private String trellis;
	 //* -sc_threshold 40
	private String sc_threshold;
	 //* -i_qfactor 0.71
	private String i_qfactor;
	 //* -acodec libfaac 
	private String acodec;
	 //* -ab 128k
	private String ab;
	 //* -ar 48000
	private String ar;
	 //* -ac 2
	private String ac;
	 //* OUTPUT
	private String OUTPUT;
	/**format -f**/
	private String toFormat;
	//-vprofile high
	private String vprofile;
	//-preset slow
	private String preset;
	//-b %bit%
	private String b;
	//-maxrate %bit%
	private String maxrate;
	//-bufsize 800k  
	private String bufsize;
	/**视频水印**/
	private String logoFile;
	//-pass 1
	private String pass;
	
	
	/**
	 * 生成FFMpeg转换命令
	 * 
	 * @return
	 */
	public String generateFFMpegCommend(){
		StringBuffer commend= new StringBuffer();
		//-threads 4
		if(this.threads!=null) commend.append(" -threads ").append(this.threads);
		//-r 29.97 
		if(this.r!=null) commend.append(" -r ").append(this.r);
		//sourcefile
		commend.append(" -y -i ").append(this.INPUT);
		//vcodec
		if(this.vcodec!=null) commend.append(" -vcodec ").append(this.vcodec);
		//* -s 480x272||-vf scale=
		if(this.toHeight!=null) commend.append(" -s ").append(this.toHeight);
		// * -flags +loop
		if(this.flags!=null) commend.append(" -flags ").append(this.flags);
		// * -cmp +chroma
		if(this.cmp!=null) commend.append(" -cmp ").append(this.cmp);
		// * -deblockalpha 0
		if(this.deblockalpha!=null) commend.append(" -deblockalpha ").append(this.deblockalpha);
		// * -deblockbeta 0 
		if(this.deblockbeta!=null) commend.append(" -deblockbeta ").append(this.deblockbeta);
		// * -crf 24
		if(this.crf!=null) commend.append(" -crf ").append(this.crf);
		// * -bt 256k
		if(this.bt!=null) commend.append(" -bt ").append(this.bt);
		// * -refs 1
		if(this.refs!=null) commend.append(" -refs ").append(this.refs);
		// * -coder 0
		if(this.coder!=null) commend.append(" -coder ").append(this.coder);
		// * -me umh
		if(this.me!=null) commend.append(" -me ").append(this.me);
		// * -me_range 16
		if(this.me_range!=null) commend.append(" -me_range ").append(this.me_range);
		// * -subq 5
		if(this.subq!=null) commend.append(" -subq ").append(this.subq);
		// * -partitions +parti4x4+parti8x8+partp8x8 
		if(this.partitions!=null) commend.append(" -partitions ").append(this.partitions);
		// * -g 250
		if(this.g!=null) commend.append(" -g ").append(this.g);
		// * -keyint_min 25
		if(this.keyint_min!=null) commend.append(" -keyint_min ").append(this.keyint_min);
		// * -level 30
		if(this.level!=null) commend.append(" -level ").append(this.level);
		// * -qmin 10
		if(this.qmin!=null) commend.append(" -qmin ").append(this.qmin);
		// * -qmax 51
		if(this.qmax!=null) commend.append(" -qmax ").append(this.qmax);
		// * -trellis 2
		if(this.trellis!=null) commend.append(" -trellis ").append(this.trellis);
		// * -sc_threshold 40
		if(this.sc_threshold!=null) commend.append(" -sc_threshold ").append(this.sc_threshold);
		// * -i_qfactor 0.71
		if(this.i_qfactor!=null) commend.append(" -i_qfactor ").append(this.i_qfactor);
		// * -acodec libfaac
		if(this.acodec!=null) commend.append(" -acodec ").append(this.acodec);
		// * -ab 128k
		if(this.ab!=null) commend.append(" -ab ").append(this.ab);
		// * -ar 48000
		if(this.ar!=null) commend.append(" -ar ").append(this.ar);
		// * -ac 2
		if(this.ac!=null) commend.append(" -ac ").append(this.ac);
		// * OUTPUT
		//TODO 水印
		//movie=meiduo.png [wm1];movie=meiduo.png [wm2];[in][wm1] overlay=10:10 [int];[int][wm2] overlay=100:100 [out]
		// overlay=0:0 左上角
		// overlay=mainW-overlayW:0 右上角
		//overlay=mainW-overlayW:mainH-overlayH 右下角
		 //overlay=0:mainH-overlayH 左下角
		//-vf "movie=watermarklogo.png [watermark]; [in][watermark] overlay=10:10 [out]"
		//if(vp.getLogoFile()!=null){
		//	commend.append(" -vf 'movie=meiduo.png [watermark]; [in][watermark] overlay=10:10 [out]' ");
		//}
		//-vfilters “movie=0:png:logo.png [wm];movie=0:png:logo2.png [awm];[in][wm] overlay=10:mainH-overlayH-10:1 [int];[int][awm] overlay=mainW-overlayW-10:mainH-overlayH-10:1 [out]”
		//target file
		//-vcodec libx264 -vprofile high -preset slow 
		//-ar 44100 -ac 2 -acodec libvo_aacenc -b %bit% -maxrate %bit% -bufsize 800k -g 24 
		//-keyint_min 12 -s %wh% -r 24  -pass 1 -f mp4 %targetfile%
		if(this.vprofile!=null) commend.append(" -vprofile ").append(this.vprofile);
		if(this.preset!=null) commend.append(" -preset ").append(this.preset);
		if(this.b!=null) commend.append(" -b:v ").append(this.b);
		if(this.maxrate!=null) commend.append(" -maxrate ").append(this.maxrate);
		if(this.bufsize!=null) commend.append(" -bufsize ").append(this.bufsize);
		if(this.pass!=null) commend.append(" -pass ").append(this.pass);
		if(this.toFormat!=null) commend.append(" -f ").append(this.toFormat);
		commend.append(" ").append(this.OUTPUT);
		
		
		return commend.toString();
	}
	
	
	
	
}
