package edu.minilive.wedu.entity.app;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.Company;

/**
 * 微喜帖
 * 
 * _tj_twtype=2
 * &_tj_pid=88906
 * &_tt=1
 * &_tj_graphicid=351828
 * &_tj_title=邵建义与高雪泉的喜帖
 * &_tj_keywords=Hello2BizUserNews
 * &id=380
 * &bid=25797
 * &wechatid=oxBTxjnOSufCR8JUft9wyfEOL3AQ
 * &pid=88906
 * &wxref=mp.weixin.qq.com
 * 
 * http://j.map.baidu.com/Jnqir
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-17 下午2:52:19
 */
@Entity
@Table(name = "TAB_APP_WEIXITIE")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiXiTie implements Serializable {
	private static final long serialVersionUID = -3570923311334545614L;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 所属微信号
	 */
	private String token;
	
	/**
	 * 请帖标题
	 */
	private String title;
	
	/**
	 * 关键词激活
	 */
	private String keyword;
	
	/**
	 * 封面图
	 */
	private String coverurl;
	
	/**
	 * 缩略图
	 */
	private String thumbnail;
	
	/**
	 * 新郎姓名
	 */
	private String groomname;
	
	/**
	 * 新娘姓名
	 */
	private String bridename;
	
	/**
	 * 新郎联系电话
	 */
	private String groommobile;
	
	/**
	 * 新娘电话
	 */
	private String bridemobile;
	
	/**
	 * 宴会日期
	 */
	private String date;
	
	/**
	 * 宴会时间
	 */
	private String time;
	
	/**
	 * 宴会地点
	 */
	private String address;
	
	/**
	 * 宴会地点-地图GPS链接
	 */
	private String locate;
	
	/**
	 * 录像视频
	 */
	private String videourl;
	
	/**
	 * 音乐链接地址
	 */
	private String musicurl;
	
	/**
	 * 新郎与新娘 想说的话
	 */
	private String content;
	
	
	
	/**
	 * 状态，1——正常，2——删除
	 */
	private int state = 1;
	
	/**
	 * 所属单位（单位管理号）
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="company_id")
	private Company company;
}
