package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 微遗愿
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-8 下午2:53:47
 */
@Entity
@Table(name = "TAB_APP_WEIWISHES")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiWishes {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 所属微信号
	 */
	private String openId;
	
	/**
	 * 消息ID
	 */
	private String msgId;
	
	/**
	 * 标题
	 */
	private String title;
	
	/** 时间 **/
	private Date createDate;
	
	/**
	 * 状态，1——正常，2——删除
	 */
	private int state = 1;
	
	/**
	 * 文本内容
	 */
	private String content;
	
	/**
	 * 语音
	 */
	private String voice;
	
	/**
	 * 视频
	 */
	private String video;
}
