package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;

/**
 * 微相册照片
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-17 下午2:52:19
 */
@Entity
@Table(name = "TAB_APP_WEIPHOTO")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiPhoto {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 请帖标题
	 */
	private String title;
	
	/**
	 * 状态，1——正常，2——删除，3——刚上传
	 */
	private int state = 1;
	
	/**
	 * 缩略图
	 */
	private String thumbnail;
	
	/**
	 * 大图地址
	 */
	private String picurl;
	
	/**
	 * 照片描述
	 */
	private String content;
	
	
	/** 创建日期 (排序)**/
	private Date createDate;
	
	/**
	 * 所属微信号
	 */
	private String token;
	
	/**
	 *  所属用户
	 * **/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="user_id")
	private User user;
	
	/**
	 * 所属相册
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="weiAlbum_id")
	private WeiAlbum weiAlbum;
	
	/**
	 * 所属单位（单位管理号）
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="company_id")
	private Company company;

}
