package edu.minilive.wedu.entity.app;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;


/**
 * 历史消息表（用户在微信端请求过来的内容）
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-7 下午2:22:39
 */
@Entity
@Table(name = "TAB_WXMESSAGES")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WXMessages implements Serializable {
	private static final long serialVersionUID = -8081325730249851166L;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 1l; //主键
	
	
	private String openID;	//微信用户OpenID
	
	private Long schoolId;	//学校编号
	
	/**
	 * 1-文本消息，2-菜单消息
	 */
	private int messageType;	//消息类型
	
	/**
	 * 消息内容
	 */
	private String messagebody;
	/**
	 * 发送时间
	 */
	private Date createDate;
	
	
}
