package edu.minilive.wedu.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;



/**
 * 用户基础表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author Author：        <JannyShao>
 * Create Date：  <2013-6-24 上午9:46:14>
 * 
 * 
 */
@Entity
@Table(name = "TAB_USER")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class User  {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键

//=================基础信息================================================
	 /**
     * 登陆用户名(登陆号)       db_column: username 
     */ 	
	private String username;
    /**
     * 用户密码       db_column: password 
     */ 	
	private String password;
	/**
	 * 昵称(小名)
	 */
	private String nickname;
	/**
     * 是否被禁用(1-正常,2-禁用)       db_column: enabled 
     */ 	
	private int enable = 1;
	//性别 1-男，2-女，0-保密
	private int sex = 0;
	//手机信息
	private String mobile;
	//邮箱
	private String email;
	/**
	 * 证件类型
	 * 1-大陆身份证,2-港澳台身份证,3-学生证,4-军官证,5-护照
	 */
	private int identityType = 1;
	/**
	 * 证件号码
	 */
	private String identity;
	//证件复印件
	private String identityfile;
	
	/**
	 * 自我介绍
	 */
	private String introduction;
	
//=================头像照片================================================
	/**
	 * 用户头像
	 */
	private String userface;

//=================三方登录ID================================================
	/**
	 * QQ OpenId
	 */
	private String qqId;
	
	/**
	 * 新浪 Open id
	 */
	private String sinaId;                       // required; unique
	
	/**
	 * 紫悦新橙id
	 */
	private String ukId;
	
	/**
	 * 微信Open id
	 */
	private String weixinId;
	/**
	 * 用户类型:::
	 * 1-学生:暂时不支持
	 * 2-老师:投稿，收藏，踩，赞，评论等
	 * 3-系统管理员:可以进入到后台管理
	 * ....**/
	private int type = 2;
	
	/**
	 * 备注
	 */
	private String remark;
	
	
	/**
	 * 创建时间
	 */
	private Date createDate;
	
	/**
	 * 当前所在学校
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="school_id")
	private Company school;	
}
