package edu.minilive.wedu.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 单位(学校)应用表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午2:42:34
 */
@Entity
@Table(name = "TAB_COMPANY_APP")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class CompanyApp {
	
	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 应用状态:1-启动,2-禁用(当此处为2时,所有单位里的用户,都禁用)
	 */
	private int state = 1;
	
	/**
	 * 创建日期
	 */
	private Date	createDate;

	/**
	 * 微应用类型(学校设置,
	 * <li>1-公开应用[适用于全校用户]
	 * <li>2-OA应用[适用于教师用户、需要绑定后访问]
	 */
	private int apptype = 1;
	
	/**
	 * 是否显示在微官网：0-隐藏，1-显示
	 */
	private int showApp = 0;
	
	/**
	 * 应用别名(示：WeiPhoto，WeiVideo...)
	 */
	private String appalias;
	
	/**
	 * 应用
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="app_id")
	private App app;
	
	/**
	 * 所属学校
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="company_id")
	private Company company;		
	
}
