package edu.minilive.wedu.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;



/**
 * 
 * 单位表（校园表）
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-6 上午9:51:07
 */
@Entity
@Table(name="TAB_COMPANY")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class Company {
	
	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/** 单位/学校  名称  **/
	private String name; //单位名称
	/**
	 * 单位别名
	 */
	private String alias;	
	
	/** 联系电话  **/
	private String telphone; //联系电话
	
	/** 网址  **/
	private String website; //网址
	
	/** 邮编  **/
	private String postcode; //邮编
	
	/** 创建日期  **/
	private Date createDate; //创建日期
	
	/** 状态 0-新申请 1-正常 2-注销  3-未通过(驳回) 4-待审核**/
	private int status; //状态 1-正常 2-注销3-未审核
	
	/**
	 * 验证状态
	 * 待验证 （0） 验证通过 （1）  验证中 （2） 验证驳回 （3）
	 */
	private int vertystate = 0;
	
	
	
	/** 
	 * 教育、金融、医疗、会计、法律、美容、婚庆、其它
	 * 
	 *   **/
	private int type = 0;          //单位类型
	
	/**
	 * 单位类型(1-学校,2-单位,...etc)
	 * @see 学校类别 (1000-幼儿园 1001-小学 1002-初中 1003-高中 1004-职教)
	 * 		2000-公办园所,2001-民办园所,2002-合作园所,2003-早教机构
	 */
	private int subtype=0;
	
	/**
	 * 备注
	 */
	private String remark;
	
	//=============================申请入驻时需要的材料==============================
	/** 单位联系人  **/
	private String contact; //单位联系人
	//联系手机
	private String mobile; 
	/** 邮箱  **/
	private String email; //邮箱
	/** 联系地址  **/
	private String address; //联系地址
	/** 省  **/
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="provinceId")
	private District province; //省
	/** 市  **/
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="cityId")
	private District city; //市
	/** 区、县  **/
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="areaId")
	private District area; //区、县
	/** 单位简介  **/
	private String introduction;  //单位简介
	//营业执照
	private String businesslicensefile;
	//组织机构代码证
	private String orgcodefile;
	
	//=============================微信公众平台需要的材料==============================
	/**微信公众平台TOKEN**/
	private String WXToken;		//微信公众平台TOKEN
	private String WXTokenKey;	//连接密码
	
	/**微信同步菜单时使用**/
	private String wxAppId;
	/**微信同步菜单时使用**/
	private String wxAppSecret;
	
	//`weixin` char(20) NOT NULL COMMENT '微信号',
	private String weixin;
	
	//公众帐号类型：1-订阅号  2-认证订阅号 3-服务号 4-高级服务号
	private int weixintype;
	
	//`tpltypeid` varchar(2) NOT NULL default '1' COMMENT '默认首页模版ID',
	private String tpltypeid = "1";
	//`tpltypename` varchar(20) NOT NULL COMMENT '首页模版名',
	private String tpltypename ;
	//`tpllistid` varchar(2) NOT NULL COMMENT '列表模版ID',
	//`tpllistname` varchar(20) NOT NULL COMMENT '列表模版名',
	//`tplcontentid` varchar(2) NOT NULL COMMENT '内容模版ID',
	//`tplcontentname` varchar(20) NOT NULL COMMENT '内容模版名',
	//`color_id` mediumint(4) NOT NULL default '0',
	private String headerpic;
	//`headerpic` char(255) NOT NULL COMMENT '图文消息封面',
	
	
	//=============================审核验证相关信息==============================
	/** 审核时间 **/
	private Date verifyDate;
	
	/** 审核时间人 **/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="verifyuser_id")
	private User verifyuser;
	
	
	
}
