package edu.minilive.wedu.entity;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.ecompus.core.util.HttpUtil;

/**
 * 文章表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-10-8 下午3:08:12
 */
@Entity
@Table(name = "TAB_ARTICLE")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class Article  {
	
	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 标题
	 */
	private String title;
	
	/***
	 * 副标题,主要用于微信图文说明
	 */
	private String subtitle;
	
	/**
	 * 内容
	 * @TYPE:LONGTEXT
	 */
	private String text;
	
	/**	关键词/标签 **/
	private String tags;
	
	/**微信频道**/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="channel_id")
	private Channel channel;
	
	/** 文章所属者 **/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="user_id")
	private User user;
	
	/**
	 * 所属学校
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="school_id")
	private Company school;
	
	
	/** 状态:1-正常,2-注销**/
	private int state = 1;
	
	/** 创建日期 (排序)**/
	private Date createDate;
	
	/**
	 * 阅读次数
	 */
	private Long clickCount = 0l;

	/**
	 * 获取文章图片链接地址
	 * @return
	 */
	@Transient
	public String getTextImg()
	{
		if(text!=null && !"".equals(text)){
			String img="";        
	        Pattern p_image;        
	        Matcher m_image;        
	       
	        String regEx_img = "<img.*src=(.*?)[^>]*?>"; //图片链接地址        
	        p_image = Pattern.compile(regEx_img,Pattern.CASE_INSENSITIVE);
	        
	        m_image = p_image.matcher(HttpUtil.encodeHtml(text));  
	        while(m_image.find()){ 
	        	img = img + "," + m_image.group();
	        	Matcher m  = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img); //匹配src     
	            while(m.find()){
	            	String url = m.group(1);
	            	url = url.replace("'", "");
	               return url;     
	            } 
	        }
		}
		
		return "";
	}
	
}
