package edu.minilive.wedu.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.WeiVideoDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;
import edu.minilive.wedu.entity.app.WeiVideo;

/**
 * 
 * <B>教育微频</B> 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-7 下午5:25:12
 */
@Repository
public class WeiVideoDaoImpl extends ML2TemplateGenericDao<WeiVideo> implements
		WeiVideoDAO {

	/**
	 * 查询单位视频数量
	 * Long count = (Long) queryForObject(" select count (*)  from Video v where v.status in(1,3)  and v.company=?", new Object[]{company});
		return count.intValue();
	 */
	/**
	 * 
	 */
	public WeiVideoDaoImpl() {
		super(WeiVideo.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<WeiVideo> queryCompanyVideo(Company company, Page page) {
		StringBuffer sql = new StringBuffer("from WeiVideo v where v.id>0");
		
		if(company!=null){
			sql.append(" and v.company.id='").append(company.getId()).append("'");
		}
		
		sql.append(" and status=1 order by v.itop desc, v.createDate desc");
		
		if(page!=null){
			return this.queryForList(
					"select count(*) " + sql.toString(),
					sql.toString(),
					new Object[] {}, page);
		}else{
			return this.hibernateTemplate.find(sql.toString());
		}
	}

	@Override
	public void updateVideoStatus(Long videoId, int status) {
		WeiVideo video = this.query(videoId);
		if(video!=null){
			video.setStatus(status);
			this.update(video);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<WeiVideo> queryVideoList(String title, int status, User user,
			Company company, int subject, Page page) {
		StringBuffer sql = new StringBuffer("from WeiVideo v where v.id>0");
		
		if(title!=null && !"".equals(title))
		{
			sql.append(" and v.title like '%").append(title).append("%'");
		}
		
		//查询除了注销状态以外的所有状态视频
		if(status==-2){
			sql.append(" and v.status <> 2");
		}else if(status==-1){
			//不为条件
		}else{
			sql.append(" and v.status=").append(status);
		}
		
		if(user!=null){
			sql.append(" and v.user.id='").append(user.getId()).append("'");
		}
		
		
		if(company!=null){
			sql.append(" and v.company.id='").append(company.getId()).append("'");
		}
		
		
		if(subject!=-1)
		{
			sql.append(" and v.subject=").append(subject);
		}

		sql.append(" order by v.createDate desc");
		
		
		if(page!=null){
			return this.queryForList(
					"select count(*) " + sql.toString(),
					sql.toString(),
					new Object[] {}, page);
		}else{
			return this.hibernateTemplate.find(sql.toString());
		}
		
	}

}
