package edu.minilive.wedu.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.minilive.wedu.dao.WeiVideoConfigDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.app.WeiVideoConfig;

/**
 * 
 * <B>教育微频-脚本配置</B> 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-7 下午5:25:12
 */
@Repository
public class WeiVideoConfigDaoImpl extends ML2TemplateGenericDao<WeiVideoConfig> implements
		WeiVideoConfigDAO {


	public WeiVideoConfigDaoImpl() {
		super(WeiVideoConfig.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public WeiVideoConfig queryWeiVideoConfigByCompany(Company company) {
		List<WeiVideoConfig> list = this.hibernateTemplate.find("from WeiVideoConfig vf where vf.company.id=? order by vf.createDate desc", new Object[]{company.getId()}); 
		if(list.size()>0){
			return list.get(0);
		}
		
		return null;
	}

}
