package edu.minilive.wedu.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.WXMessagesDAO;
import edu.minilive.wedu.entity.app.WXMessages;

/**
 * <b>微信历史消息记录表</b> 数据持久类 操作接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-3 上午11:47:05
 */
@Repository
public class WXMessagesDaoImpl extends ML2TemplateGenericDao<WXMessages> implements
		WXMessagesDAO {

	public WXMessagesDaoImpl() {
		super(WXMessages.class);
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<WXMessages> queryNewestList(Page page) {
		StringBuffer sql = new StringBuffer("from WXMessages where id>0 ");
		sql.append(" order by createDate desc");
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}

}
