package edu.minilive.wedu.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.FocusAdDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.FocusAd;
/**
 * 广告DAO 操作接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:26:01
 */
@Repository
public class FocusAdDaoImpl extends ML2TemplateGenericDao<FocusAd> implements
		FocusAdDAO {

	public FocusAdDaoImpl() {
		super(FocusAd.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<FocusAd> queryFocusAdByCompany(Company company, String keyword,
			int type, Page page) {
		StringBuffer sql = new StringBuffer("from FocusAd where state=1 ");
		
		if(company!=null){
			sql.append(" and school.id=").append(company.getId());
		}
		
		if(keyword!=null && !"".equals(keyword)){
			sql.append(" and title like '%").append(keyword).append("%'");
		}
		
		if(type!=-1){
			sql.append(" and type=").append(type);
		}
		
		sql.append(" order by orderNo asc,createDate desc");
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<FocusAd> queryFocusAdByType(int type) {
		StringBuffer sql = new StringBuffer("from FocusAd where state=1 and school.id is null");
		
		if(type!=-1){
			sql.append(" and type=").append(type);
		}
		
		sql.append(" order by orderNo asc,createDate desc");
		
		return this.hibernateTemplate.find(sql.toString());
	}

}
