package edu.minilive.wedu.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.minilive.wedu.dao.DistrictDAO;
import edu.minilive.wedu.entity.District;

/**
 * 
 * <B>地区</B> 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-7 下午5:25:12
 */
@Repository
public class DistrictDaoImpl extends ML2TemplateGenericDao<District> implements
		DistrictDAO {


	public DistrictDaoImpl() {
		super(District.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<District> queryAllProvince() {
		return this.hibernateTemplate.find("from District where parent_id=0");
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<District> queryProvinceFuzzy(String provinceName) {
		if(provinceName!=null && !"".equals(provinceName)){
			return this.hibernateTemplate.find("from District where parent_id=0 and name like '%"+provinceName+"%'");
		}
		
		return queryAllProvince();
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<District> queryCityFuzzy(String cityName, District province) {
		StringBuffer sql = new StringBuffer("from District c where c.id > 0");
		if(cityName!=null && !"".equals(cityName)){
			sql.append(" and c.name like '%").append(cityName).append("%'");
		}
		
		if(province!=null){
			sql.append(" and c.parent_id='").append(province.getId()).append("'");
		}
		
		return this.hibernateTemplate.find(sql.toString());
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<District> queryAreaFuzzy(String areaName, District city) {
		StringBuffer sql = new StringBuffer("from District c where c.id > 0");
		if(areaName!=null && !"".equals(areaName)){
			sql.append(" and c.name like '%").append(areaName).append("%'");
		}
		
		if(city!=null){
			sql.append(" and c.parent_id='").append(city.getId()).append("'");
		}
		
		return this.hibernateTemplate.find(sql.toString());
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<District> queryDistrictListByIds(String ids) {
		return this.hibernateTemplate.find("from District where id in (" + ids + ")");
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<District> queryAreaList(Long cityId) {
		return this.hibernateTemplate.find("from District c where c.parent_id='"+cityId+"'",new Object[]{});
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<District> queryCityList(Long provinceId) {
		return this.hibernateTemplate.find("from District c where c.parent_id='"+provinceId+"'",new Object[]{});
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<District> queryFuzzy(String name, int level) {
		StringBuffer sql = new StringBuffer("from District c where c.id > 0");
		if(name!=null && !"".equals(name)){
			sql.append(" and c.name like '%").append(name).append("%'");
		}
		
		if(level!=-1){
			sql.append(" and c.level=").append(level);
		}
		
		return this.hibernateTemplate.find(sql.toString());
	}


}
