package edu.minilive.wedu.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.CustomMenuDAO;
import edu.minilive.wedu.entity.CustomMenu;

/**
 * 
 * <b>自定义菜单</b> 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
@Repository
public class CustomMenuDaoImpl extends ML2TemplateGenericDao<CustomMenu> implements
		CustomMenuDAO {

	public CustomMenuDaoImpl() {
		super(CustomMenu.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<CustomMenu> queryCustomMenuListByCompanyId(Long schoolId,
			int level) {
		
		StringBuffer sql = new StringBuffer("from CustomMenu where state=1 ");
		if(schoolId!=null && schoolId>0l){
			sql.append(" and schoolId=").append(schoolId);
		}
		
		if(level!=-1){
			sql.append(" and level=").append(level);
		}
		
		sql.append(" order by orderby asc");
		
		return this.hibernateTemplate.find(sql.toString());
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<CustomMenu> queryCustomMenuByEventKey(String eventKey, Page page) {
		StringBuffer sql = new StringBuffer("from CustomMenu where state=1 ");
		
		if(eventKey!=null && !"".equals(eventKey)){
			sql.append(" and clickKey='").append(eventKey).append("'");
		}
		
		sql.append(" order by orderby desc");
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}


}
