package edu.minilive.wedu.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.ChannelDAO;
import edu.minilive.wedu.entity.Channel;
import edu.minilive.wedu.entity.Company;
/**
 * <b>栏目</b> 数据持久类 操作接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 下午3:31:58
 */
@Repository
public class ChannelDaoImpl extends ML2TemplateGenericDao<Channel> implements
		ChannelDAO {


	public ChannelDaoImpl() {
		super(Channel.class);
	}

	@Override
	public Channel queryChannelByAlias(String alias) {
		StringBuffer sql = new StringBuffer("from Channel where id>0 ");
		sql.append(" and alias='").append(alias).append("'");
		
		return (Channel) this.queryForObject(sql.toString(), null);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Channel> queryChannelListByParent(Channel channel) {
		StringBuffer sql = new StringBuffer("from Channel where state=1 ");
		if(channel!=null){
			sql.append(" and parent.id=").append(channel.getId());
		}
		
		return this.hibernateTemplate.find(sql.toString());
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Channel> queryChannelList() {
		StringBuffer sql = new StringBuffer("from Channel where state=1 and parent.id is null ");
		
		return this.hibernateTemplate.find(sql.toString());
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Channel> queryChannelByCompany(Company company, Channel parentChannel, Page page) {
		StringBuffer sql = new StringBuffer("from Channel where state=1 ");
		if(company!=null){
			sql.append(" and school.id=").append(company.getId());
		}
		
		if(parentChannel!=null){
			sql.append(" and parent.id=").append(parentChannel.getId());
		}else{
			sql.append(" and parent.id is null");
		}
		
		sql.append(" order by orderNo asc,createDate desc");
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}

}
