package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;
import edu.minilive.wedu.entity.app.WeiVideo;

/**
 * <b>教育微频-微应用</b> 数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-6 下午3:02:37
 */
public interface WeiVideoDAO extends ML2GenericDao<WeiVideo> {
	
	/**
	 * 查询单位所有有效的视频
	 * <li>条件：status=1
	 * <li>Order: istop, updataDate desc, uploadDate desc 
	 * @param company	单位实体
	 * @return
	 */
	List<WeiVideo> queryCompanyVideo(Company company, Page page);
	
	/**
	 * 仅仅更新视频状态
	 * 
	 * @param videoId
	 * @param status	@see ConvertState
	 */
	public void updateVideoStatus(Long videoId, int status);
	
	/**
	 * 根据综合条件查询视频列表
	 * @param title			关键词（like,null或者空不为条件）
	 * @param status		状态（-1不为条件，-2除注销状态以外，具体详见Video.status)
	 * @param user			用户（null不为条件）
	 * @param company		所属单位（null不为条件）
	 * @param subject		分类（null或者空不为条件，具体详见com.eduvideo.common.bean.SubjectList)
	 * @param page			分页
	 * @return
	 */
	public List<WeiVideo> queryVideoList(String title, int status, User user, Company company,int subject, Page page);
}
