package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.app.WeiAlbum;
import edu.minilive.wedu.entity.app.WeiPhoto;

/**
 * <b>微相册-微应用</b> 数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-6 下午3:02:37
 */
public interface WeiPhotoDAO extends ML2GenericDao<WeiPhoto> {
	
	/**
	 * 根据Token查询相册列表
	 * @param token
	 * @param company
	 * @param page
	 * @return
	 */
	List<WeiPhoto> queryPhotoListByToken(String token, Company company, Page page);
	
	/**
	 * 根据单位或者相册查询照片列表
	 * @param title
	 * @param company
	 * @param weiAlbum
	 * @param page
	 * @return
	 */
	List<WeiPhoto> queryPhotoListByCompany(String title, Company company, WeiAlbum weiAlbum, Page page  );

	/**
	 * 根据photoIds查询相册列表
	 * @param photoIds 照片ID(多个)
	 * @return
	 */
	List<WeiPhoto> queryPhotoListByIds(String photoIds, Company company, WeiAlbum weiAlbum, Page page);
	
	/**
	 * 统计该相册的相片总数
	 * @param weiAlbum
	 * @return
	 */
	Long countAlbumPhoto(WeiAlbum weiAlbum);
}
