package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.CustomMenu;
/**
 * 
 * <b>自定义菜单</b> 数据持久类 操作接口定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
public interface CustomMenuDAO extends ML2GenericDao<CustomMenu> {
	/**
	 * 查询学校菜单
	 * @param schoolId 学校ID
	 * @param level		级别,1-一级栏目,2-二级栏目
	 * @return
	 */
	List<CustomMenu> queryCustomMenuListByCompanyId(Long schoolId,int level);

	/**
	 * 根据eventKey读取菜单列表
	 * @param eventKey
	 * @return
	 */
	List<CustomMenu> queryCustomMenuByEventKey(String eventKey, Page page);
}
