package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Channel;
import edu.minilive.wedu.entity.Company;

/**
 * 
 * <b>栏目</b> 数据持久类 操作接口定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
public interface ChannelDAO extends ML2GenericDao<Channel> {
	/**
	 * 根据别名查询频道
	 * @param alias
	 * @return
	 */
	Channel queryChannelByAlias(String alias);
	
	/**
	 * 根据父频道查询子频道列表
	 * @param channel
	 * @return
	 */
	List<Channel> queryChannelListByParent(Channel channel);
	
	/**
	 * 读取一级栏目
	 * @return
	 */
	List<Channel> queryChannelList();
	
	/**
	 * 读取学校、单位栏目列表
	 * @param company		单位实体
	 * @param parentChannel	父频道（NULL时读取顶级栏目）
	 * @param page			分页（NULL，读取所有）
	 * @return
	 */
	List<Channel> queryChannelByCompany(Company company, Channel parentChannel, Page page);
}
