package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.AutoRespond;

/**
 * 
 * <b>自动回复表</b> 数据持久类 操作接口定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
public interface AutoRespondDAO extends ML2GenericDao<AutoRespond> {

	/**
	 * 读取学校自动回复列表
	 * @param school
	 * @param page
	 * @return
	 */
	List<AutoRespond> queryAutoRespondListByCompany(Long schoolId, Page page);

	/**
	 * 读取学校自动回复列表
	 * @param school	企事业单位
	 * @param type		类型0-关注时欢迎消息，1-文字，2-图文
	 * @param page
	 * @return
	 */
	List<AutoRespond> queryAutoRespondListByType(Long schoolid, int type, Page page);

	/**
	 * 根据schoolid/keyIdy读取自动回复设置列表
	 * @param schoolid
	 * @param keyId
	 * @param page
	 * @return
	 */
	List<AutoRespond> queryAutoRespondByClickKey(Long schoolid, String keyId, Page page);
	
	/**
	 * 根据schoolid/keyIdy读取自动回复设置列表
	 * @param schoolid
	 * @param likekey
	 * @param page
	 * @return
	 */
	List<AutoRespond> queryAutoRespondByClickKeyLike(Long schoolid, String likekey, Page page);

}
