package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Article;
import edu.minilive.wedu.entity.User;

/**
 * <b>文章、内容</b> 数据持久类 操作接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:21:58
 */
public interface ArticleDAO extends ML2GenericDao<Article> {
	
	
	/**
	 * 读取栏目列表
	 * @param channelId		栏目ID（-1或者NULL不为条件）
	 * @param page
	 * @return
	 */
	List<Article> queryChannelList(Long channelId,Page page);
	
	
	/**
	 * 根据作者读取列表
	 * @param user
	 * @param page
	 * @return
	 */
	List<Article> queryArticleByUser(User user, Page page);
	
	
	/**
	 * 根据关键词查询文章列表
	 * @param keyword
	 * @param page
	 * @return
	 */
	List<Article> queryArticleByKeyword(String keyword, Page page);
	
	/**
	 * 根据标签查询文章列表
	 * @param tag
	 * @param page
	 * @return
	 */
	List<Article> queryArticleByTag(String tag, Page page);


	/**
	 * 查询单位文章列表【单位后台】
	 * @param company		单位
	 * @param keyword		关键词
	 * @param channel		所属栏目
	 * @param page			分页（NULL读取所有）
	 * @return
	 */
	List<Article> queryArticleListByCompany(Long companyId, String keyword, Long channelId, Page page);
	
	
}
