package edu.minilive.wedu.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

/**
 * 
 * 字符工具类
 * 
 * CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 * <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK version used:
 * <JDK1.6>
 * 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-15 下午5:28:34
 */
public class StringUtil {
	public static boolean isEmpty(String s) {
		if (s == null) {
			return true;
		}

		if (s.length() == 0) {
			return true;
		}

		return false;
	}

	public static boolean isEmpty(Object[] objs) {
		if (objs == null || objs.length == 0)
			return true;
		else
			return false;
	}

	/**
	 * Append every elements in names array into buff. Some like:
	 * names[0]${appendSting}${seperator}names[1]${appendString
	 * }${seperator}...names[n-1]${appendString}.
	 * 
	 * 
	 * <p>
	 * Exapmle: INSERT SQL can be appended with: append( buff, names, false,
	 * "?", "," ); UPDATE SQL can be appended with: append( buff, names, true,
	 * "=?", "," ); WHERE SQL can be appended with: append( buff, names, true,
	 * "=?", " AND " );
	 * 
	 * @param buff
	 * @param names
	 * @param displayName
	 *            If true, append every names[i] into buff, else names[i] is not
	 *            appended
	 * @param appendString
	 * @param seperator
	 */
	public static void append(StringBuffer buff, String[] names,
			boolean displayName, String appendString, String seperator) {
		if (isEmpty(names))
			return;

		if (displayName)
			buff.append(names[0]);
		buff.append(appendString);

		for (int i = 1; i < names.length; i++) {
			buff.append(seperator);
			if (displayName)
				buff.append(names[i]);
			buff.append(appendString);
		}
	}

	public static String[] split(String s, String token) {
		if (s == null) {
			return null;
		}

		StringTokenizer st = new StringTokenizer(s, token);
		int size = st.countTokens();
		String[] result = new String[size];
		for (int i = 0; i < size; i++) {
			result[i] = st.nextToken();
		}

		return result;
	}

	public static String[] splitAndTrim(String s, String token) {
		if (s == null) {
			return null;
		}

		StringTokenizer st = new StringTokenizer(s, token);
		int size = st.countTokens();
		String[] result = new String[size];
		for (int i = 0; i < size; i++) {
			result[i] = st.nextToken().trim();
		}

		return result;
	}

	/**
	 * Resever whitespace, breakline into <content>
	 */
	public static String keepSpaceInContent(String xmlStr, String content) {
		StringBuffer xml = new StringBuffer(xmlStr);
		int start = xml.indexOf("<content>");
		int end = xml.indexOf("</content>");

		xml.replace(start, end, "<content xml:space=\"preserve\"><![CDATA["
				+ content + "]]>");

		return xml.toString();
	}

	public static String getEvalError(String error) {
		StringBuffer buff = new StringBuffer(error);
		int start = buff.indexOf("Sourced file:");
		int end = buff.indexOf(". . . '' : ");
		if (start >= 0 && end >= 0 && start < end) {
			buff.replace(start, end + 11, "");
		}

		return buff.toString();
	}

	public static String toJavascriptValue(String[] s) {
		StringBuffer buff = new StringBuffer();
		buff.append("");
		for (int i = 0; i < s.length; i++) {
			String t = s[i];
			if (i > 0) {
				buff.append(",");
			}
			buff.append("'").append(t).append("'");
		}

		return buff.toString();
	}

	/**
	 * 将字符串(字段),以split分隔成List<String>
	 * 
	 * @param column
	 * @param split
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static Set<String> column2List(String column, String split) {
		if (column != null && !column.isEmpty()) {
			String[] list = column.split(split);

			return new HashSet(Arrays.asList(list));
		}

		return null;
	}

	/**
	 * 生成脚本内容
	 * 
	 * @param u
	 * @param path
	 * @return
	 */
	public static boolean generateJavascript(String filePath, String jscontent) {
		long beginDate = (new Date()).getTime();
		try {
			PrintStream printStream = new PrintStream(new FileOutputStream(filePath)); 
			printStream.println(jscontent); 
			System.out.println("共用时：" + ((new Date()).getTime() - beginDate) + "ms");
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
}
