package edu.minilive.wedu.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import edu.ecompus.core.util.MD5Util;

public class ShortUrlUtil {

	static String urlTitle = "http://t.cn/";
	static Pattern longPattern = Pattern.compile("html");// 定义一个模型
	static Pattern shortPattern = Pattern.compile(urlTitle);// 定义一个模型

	// 长连接： http://www.young-sun.com
	// 解析后的短链接为： http://***/Nvqqem
	public static String CreateShortUrl(String LongUrl, String urlTitle) {

		// 最终生成数组字符串里面包含4个shortUrl
		String[] aResult = shortUrl(LongUrl);
		// 取得4个中的任意一个字符串与urlTitle组合成为最终Url
		String shortUrl = urlTitle + aResult[2] + " ";

		return shortUrl;
	}

	public static String[] shortUrl(String url) {
		// 可以自定义生成 MD5 加密字符传前的混合 KEY
		String key = "libotao";
		// 要使用生成 URL 的字符
		String[] chars = new String[] { "a", "b", "c", "d", "e", "f", "g", "h",
				"i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t",
				"u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5",
				"6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H",
				"I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T",
				"U", "V", "W", "X", "Y", "Z" };
		// 对传入网址进行 MD5 加密
		String sMD5EncryptResult = (MD5Util.md5Hex(key + url));
		String hex = sMD5EncryptResult;
		String[] resUrl = new String[4];
		// 得到 4组短链接字符串
		for (int i = 0; i < 4; i++) {
			// 把加密字符按照 8 位一组 16 进制与 0x3FFFFFFF 进行位与运算
			String sTempSubString = hex.substring(i * 8, i * 8 + 8);
			// 这里需要使用 long 型来转换，因为 Inteper .parseInt() 只能处理 31 位 , 首位为符号位 , 如果不用
			// long ，则会越界
			long lHexLong = 0x3FFFFFFF & Long.parseLong(sTempSubString, 16);
			String outChars = "";
			// 循环获得每组6位的字符串
			for (int j = 0; j < 6; j++) {
				// 把得到的值与 0x0000003D 进行位与运算，取得字符数组 chars 索引
				// (具体需要看chars数组的长度 以防下标溢出，注意起点为0)
				long index = 0x0000003D & lHexLong;
				// 把取得的字符相加
				outChars += chars[(int) index];
				// 每次循环按位右移 5 位
				lHexLong = lHexLong >> 5;
			}
			// 把字符串存入对应索引的输出数组
			resUrl[i] = outChars;
		}
		return resUrl;
	}

	/**
	 * 处理在线视频发布内容
	 * 
	 * @param videoUrl
	 * @return
	 */
	public String changeContentBody(String videoUrl) {

		Matcher lmatcher = longPattern.matcher(videoUrl);
		Matcher smatcher = shortPattern.matcher(videoUrl);
		boolean isExsitLUrl = lmatcher.find();
		boolean isExsitSUrl = smatcher.find();
		String contetnBody = null;
		if (isExsitLUrl) {
			String[] str = videoUrl.split(".html", -1);// 将longUrl分割成多个
			int urlNum = str.length - 1;// 里面包含多少个longUrl
			System.out.println(urlNum);
			for (int i = 0; i < urlNum; i++) {
				String lUrl0 = str[i] + ".html";
				String lUrl = lUrl0.substring(lUrl0.lastIndexOf("http://"),
						lUrl0.indexOf(".html") + 5);
				
				String sUrl = ShortUrlUtil.CreateShortUrl(lUrl, urlTitle);// 创建短Url

				// Url url = new Url();//todo
				contetnBody = videoUrl.replaceAll(lUrl, sUrl);
			}

			System.out.println(contetnBody);
		}
		if (isExsitSUrl) {
			String[] str = videoUrl.split(urlTitle);// 将shortUrl分割成多个
			int urlNum = str.length;// 里面包含多少个shortUrl
			System.out.println(urlNum);
			for (int i = 1; i < urlNum; i++) {
				String lUrl1 = str[i];
				System.out.println(urlTitle + lUrl1.substring(0, 7));

				// Url url = new Url();//todo
			}
			System.out.println("isShort..");
		}

		return "";
	}

	/**
	 * 移除数组中重复的元素 by wsh
	 * 
	 * @param arry
	 * @return
	 */
	public static String[] removeRepeat(String arry[]) {
		// 第一步：将字符串数组转化为字符串list；
		List<String> strList = Arrays.asList(arry);
		// 第二步：将字符串list转化为hashset.利用hashset无重复元 素的特性解决问题。
		Set<String> strSet = new HashSet<String>(strList);
		String[] newArray = new String[strSet.size()];
		Iterator<String> ite = strSet.iterator();
		for (int i = 0; ite.hasNext(); i++) {
			newArray[i] = ite.next();
		}
		return newArray;
	}

	/**
	 * 获取字符串中所包含的shortUrl(并移除重复的shortUrl)
	 * 
	 * @param str
	 * @return String[]
	 */
	public static String[] getShortUrlArray(String str) {

		// 空数组
		String[] s = new String[0];
		if (str !=null && str.contains("http://v.cn/") && str.contains(" ")) {
			// 将shortUrl分割成多个
			String[] strArray = str.split(" ");
			List<String> strList = new ArrayList<String>();
			for (int i = 0; i < strArray.length; i++) {
				String a = strArray[i];
				if (strArray[i].contains("http://v.cn/")) {
					// 获取shortUrl
					String sUrl = a.substring(a.lastIndexOf("http://v.cn/"),
							a.length())
							+ " ";
					strList.add(sUrl);
				}
			}
			Set<String> strSet = new HashSet<String>(strList);
			String[] newArray = new String[strSet.size()];
			Iterator<String> ite = strSet.iterator();
			for (int i = 0; ite.hasNext(); i++) {
				newArray[i] = ite.next();
			}
			return newArray;
		}
		return s;
	}
}
