package edu.minilive.wedu.util;

import java.io.File;
import java.util.Date;

import org.springframework.web.multipart.MultipartFile;

import edu.ecompus.core.util.EnvProperUtil;

import net.coobird.thumbnailator.Thumbnails;

/**
 * 图片压缩工具类
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-11-1 上午11:51:16
 */
public class ImageThumbUtil {
	
	/**
	 * 上传图片保存，并返回路径
	 * @param path				保存地址
	 * @param thumbnailf		文件流
	 * @param width				宽
	 * @param height			高
	 * @return
	 */
	public static String getImageUrl(String path, MultipartFile file, int width, int height)  throws Exception{
		// 项目根路径
		String rootPath = EnvProperUtil.webrealpath;
		//** 文件名字 *//*
		String fileName = "tmp_" + String.valueOf(System.currentTimeMillis()); 
		//** 截取获得文件后缀名 *//*
		String fileSuffix = file.getOriginalFilename().substring(
				file.getOriginalFilename().lastIndexOf("."));
		//图片路径
		String weiboPath = File.separator + "upload" + File.separator +  path + File.separator + CommonUtil.dateformat(new Date(), "yyyyMMdd") + File.separator;
		//** 图片存放真实路径 *//*
		String uploadRealPath = rootPath + weiboPath + fileName + fileSuffix;
		File realPath = new File(uploadRealPath);
		try {
			realPath.mkdirs();
		} catch (Exception e) {
		}
		// 上传图片
		file.transferTo(realPath);
		//
		// 图片缩略图地址
		String thumbnailsPath = rootPath + weiboPath + File.separator + String.valueOf(System.currentTimeMillis()) + fileSuffix;
		// 生成缩略图
		makeScaleImage(uploadRealPath, thumbnailsPath, width, height);
		//删除临时文件
		try {
			realPath.delete();
		} catch (Exception e) {
		}
		return thumbnailsPath;
	}
	
	/**
	 * 上传图片保存，并返回路径(保留源文件）
	 * @param path
	 * @param file
	 * @param width
	 * @param height
	 * @return
	 * @throws Exception
	 */
	public static String[] getPhotoUrl(String path, MultipartFile file, int thumbnailswidth, int thumbnailsheight, int bwidth, int bheight)  throws Exception{
		// 项目根路径
		String rootPath = EnvProperUtil.webrealpath;
		//** 文件名字 *//*
		String fileName = "tmp_" + String.valueOf(System.currentTimeMillis()); 
		//** 截取获得文件后缀名 *//*
		String fileSuffix = file.getOriginalFilename().substring(
				file.getOriginalFilename().lastIndexOf("."));
		//图片路径
		String weiboPath = File.separator + "upload" + File.separator +  path + File.separator + CommonUtil.dateformat(new Date(), "yyyyMMdd") + File.separator;
		//** 图片存放真实路径 *//*
		String uploadRealPath = rootPath + weiboPath + fileName + fileSuffix;
		File realPath = new File(uploadRealPath);
		try {
			realPath.mkdirs();
		} catch (Exception e) {
		}
		// 上传图片
		file.transferTo(realPath);
		//
		// 图片缩略图地址
		String thumbnailsPath = rootPath + weiboPath + File.separator + String.valueOf(System.currentTimeMillis()) + fileSuffix;
		// 生成缩略图
		makeScaleImage(uploadRealPath, thumbnailsPath, thumbnailswidth, thumbnailsheight);
		//生成大图
		String picPath = rootPath + weiboPath + File.separator + String.valueOf(System.currentTimeMillis()) + "2" + fileSuffix;
		// 生成大图
		makeScaleImage(uploadRealPath, picPath, bwidth, bheight);
				
		String[] result = new String[2];
		result[0] = thumbnailsPath;
		result[1] = picPath; 
		return result;
	}
	
	/**
	 * 图片压缩
	 * @param srcFilePath		原图路径
	 * @param destFilePath		目标路径
	 * @param width				宽度
	 * @param height			高度
	 */
	public static void makeScaleImage(String srcFilePath, String destFilePath ,int width, int height) throws Exception{
		Thumbnails.of(new File(srcFilePath))
			.size(width, height)
	        //.rotate(90)
			//.keepAspectRatio(false)
	        //.watermark(Positions.BOTTOM_RIGHT, ImageIO.read(new File("watermark.png")), 0.5f)
	        .outputQuality(0.8f)
	        .toFile(new File(destFilePath));
	}
}
