package edu.minilive.wedu.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.ecompus.core.util.EnvProperUtil;
import edu.minilive.wedu.module.SO.ConvertStateSO;
import edu.minilive.wedu.module.SO.MediaInfoSO;
import edu.minilive.wedu.module.SO.StreamGobblerSO;
import edu.minilive.wedu.module.SO.VideoConvertParamersSO;



/**
 * <p>Title: FFmpegTrans.java</p>
 * <p>Description: SNTV平台</p>
 * <p>Copyright: Copyright(c)2011</p>
 * <p>Company: 梅朵网</p>
 * @author: wenx
 * @date: 2011-10-13下午01:43:57
 * @version V1.0.0
 */
public class FFmpegTransUtil {
	private static Logger logger = LoggerFactory.getLogger(FFmpegTransUtil.class);
	
	/**
	 * 将sourceFile转换为targetFile的MP4视频
	 * @param sourceFile
	 * @param targetFile
	 * @param wh
	 * @param rate
	 * @return
	 */
	public static synchronized int ffmpegTrans2MP4(String sourceFile, String targetFile, String wh,String rate){
		//%~dp0\ffmpeg -y -i %sourcefile% -vcodec libx264 -vprofile high -preset slow 
		//-ar 44100 -ac 2 -acodec libvo_aacenc -b %bit% -maxrate %bit% -bufsize 800k -g 24 
		//-keyint_min 12 -s %wh% -r 24  -pass 1 -f mp4 %targetfile%
		VideoConvertParamersSO vp = new VideoConvertParamersSO();
		vp.setVcodec("libx264");
		vp.setVprofile("high");
		vp.setPreset("slow");
		//vp.setAcodec("libvo_aacenc");
		vp.setAcodec("libfaac");
		
		vp.setAr("44100");
		vp.setAc("2");
		vp.setKeyint_min("12");
		vp.setG("24");
		vp.setPass("1");
		vp.setToFormat("mp4");
		//
		vp.setINPUT(sourceFile);
		vp.setOUTPUT(targetFile);
		vp.setB(rate);
		vp.setMaxrate(rate);
		vp.setToHeight(wh);
		//TODO
		return ffmpegTrans(vp);
	}
	
	/**
	 * 将sourceFile转换为targetFile的FLV视频
	 * @param sourceFile
	 * @param targetFile
	 * @return
	 */
	public static synchronized int ffmpegTrans2FLV(String sourceFile, String targetFile, String wh,String rate){
		//%~dp0\ffmpeg -y -i %sourcefile% -vcodec libx264  -vpre fast_firstpass -vpre main 
		//-ar 44100 -ac 2 -acodec libvo_aacenc -b:v %bit% -maxrate %bit% -bufsize 3000k -g 29.97 
		//-vf scale=%wh% -r 24 -pass 1 %targetfile%
		VideoConvertParamersSO vp = new VideoConvertParamersSO();
		vp.setVcodec("libx264");
		vp.setVprofile("high");
		vp.setPreset("slow");
		//vp.setAcodec("libvo_aacenc");
		vp.setAcodec("libmp3lame");
		vp.setAr("44100");
		vp.setAc("2");
		vp.setKeyint_min("12");
		//vp.setR("29.97");
		vp.setG("24");
		vp.setPass("1");
		//
		vp.setINPUT(sourceFile);
		vp.setOUTPUT(targetFile);
		vp.setB(rate);
		vp.setMaxrate(rate);
		vp.setToHeight(wh);
		//TODO
		return ffmpegTrans(vp);
		//TODO
	}
	
	/**
	 * 将mpg,wmv,3gp,avi,mov,mp4,asf,asx,flv,f4v,wmv9,rm,rmvb转换为FLV
	 * <b>flvconvert.bat 参数说明</b> <LI>源文件%1 需要转换的源文件<b> 必选</b> <LI>目标地址%2
	 * 转换后所要放的位置,最后是以目标地址%2\vid目录结构<b> 必选</b> <LI>vid=%3 视频编号<b> 必选</b> <LI>
	 * wh=%4 视频码,默认为640:480 <LI>bit=%5 转换比特率,默认786432(768bps),该值的大小决定视频的清晰度与文件大小
	 * 
	 * @param vp 转换配置参数
	 * @return int (默认返回ConvertState.FAIL)
	 * 			<li> 	ConvertState.SUCCESS	转换成功
	 * 			<li>	ConvertState.FAIL	失败
	 * 			<li> 	SOUREFILE_NOTEXISTS	源文件不存在
	 * **/
	public static synchronized int ffmpegTrans(VideoConvertParamersSO vp){
		if(vp==null) {
			logger.info("[0.0] VideoConvertParamers IS NULL");
			return ConvertStateSO.FAIL;
		}
		//目标目录不存在,则创建
		logger.info("[0.1] 源文件:"+vp.getINPUT());
		File targetDir = new File(vp.getOUTPUT());
		try
		{
			logger.info("[1.1] 创建目录文件:"+targetDir.getParentFile().mkdirs());
		}catch(Exception e){}
		
		targetDir = null;

		//生成转换命令
		StringBuffer commend= new StringBuffer();
		
		//commend.append(EnvProperUtil.webrealpath );
		//ffmpeg命令
		commend.append(EnvProperUtil.getFFmpegUrl()).append(" ");
		//commend.append("E:\\ffmpeg\\ffjob\\ffmpeg.exe");
		commend.append(vp.generateFFMpegCommend());
		
		logger.info("[2.2]开始转换"+(vp.getToFormat()!=null?vp.getToFormat():"FLV")+"视频...." );
		logger.info(commend.toString());
		try {
			Process process = Runtime.getRuntime().exec(commend.toString());
			// ffmpegOut = new BufferedReader(new InputStreamReader(process
			// .getInputStream()));
			StreamGobblerSO errorGobbler = new StreamGobblerSO(process.getErrorStream(),"ERROR");
			StreamGobblerSO outputGobbler = new StreamGobblerSO(process.getInputStream(), "OUTPUT");
			errorGobbler.start(); 
            outputGobbler.start();
			
			process.waitFor();
			logger.info("[2.3]转换结束 *********");
			//targetfile=%targetPath%\%vid%.flv
			process.destroy();
			process = null;
			
			File targetFile = new File(vp.getOUTPUT());
			if(targetFile.exists()) return ConvertStateSO.SUCCESS;
			
			errorGobbler = null;
			outputGobbler = null;
		} catch (IOException e) {
			e.printStackTrace();
			return ConvertStateSO.FAIL;
		} catch (InterruptedException e) {
			e.printStackTrace();
			return ConvertStateSO.FAIL;
		} 
		return ConvertStateSO.FAIL;
	}
	
	
	/**
	 * 利用ffmpeg截图
	 * @param videoPath			源视频地址
	 * @param targetImagePath	截图目标图片
	 * @param ss				时间秒(""或者null视为默认,默认值38)
	 * @param screenshot		截图大小(""或者null视为默认,默认值290x180)
	 * @return
	 */
	public static synchronized boolean ffmpegTransImage(String videoPath, String targetImagePath, String ss, String screenshot) {
		if(ss==null || "".equals(ss)){
			ss = "38";
		}
		
		if(screenshot==null || "".equals(screenshot)){
			screenshot = "290x180";
		}
		
		StringBuffer commend= new StringBuffer();
		commend.append(EnvProperUtil.getFFmpegUrl());
		//commend.append("E:\\ffmpeg\\ffjob\\ffmpeg.exe");
		commend.append(" -i ");
		commend.append(videoPath);
		commend.append(" -y");
		commend.append(" -f image2");
		commend.append(" -ss ").append(ss);
		commend.append(" -t 0.001");
		commend.append(" -s ").append(screenshot);
		commend.append(" -vframes 1 ");
		//commend.add("e:\\b.jpg");
		commend.append(" ").append(targetImagePath);
		logger.info(commend.toString());
		try {
			Process process=Runtime.getRuntime().exec(commend.toString());
			StreamGobblerSO errorGobbler = new StreamGobblerSO(process.getErrorStream(),"ERROR");
			StreamGobblerSO outputGobbler = new StreamGobblerSO(process.getInputStream(), "OUTPUT");
			errorGobbler.start(); 
            outputGobbler.start();
			
			process.waitFor();
			
			process.destroy();
			process = null;
				
//			outputGobbler = null;
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	
	/**
	 * 视频修护
	 * @param request 
	 * 
	 */
	public static synchronized boolean FlvRepair(String videoPath, String targetPath) {
		StringBuffer commend= new StringBuffer();
		commend.append(EnvProperUtil.getYamdiUrl());
		//commend.append("E:\\ffmpeg\\ffjob\\yamdi.exe");
		commend.append(" -i "); 
		commend.append(videoPath);
		commend.append(" -o "); 
		commend.append(targetPath); 
		logger.info(commend.toString());
		try {
			Process process=Runtime.getRuntime().exec(commend.toString());
			 //Thread.sleep(5000);
			StreamGobblerSO outputGobbler = new StreamGobblerSO(process.getInputStream(), "OUTPUT");
			outputGobbler.start();
			 process.waitFor(); 
			 
			 outputGobbler = null;

			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	
	/**
	 * MP4视频修护
	 * @param request 
	 * 
	 */
	public static synchronized boolean MP4Repair(String videoPath, String targetPath) {
		StringBuffer commend= new StringBuffer();
		commend.append(EnvProperUtil.getQtfaststartUrl());
		//commend.append("E:\\ffmpeg\\ffjob\\qt-faststart.exe");
		commend.append(" ").append(videoPath); 
		commend.append(" ").append(targetPath); 
		logger.info(commend.toString());
		try {
			Process process=Runtime.getRuntime().exec(commend.toString());
			 //Thread.sleep(5000);
			StreamGobblerSO outputGobbler = new StreamGobblerSO(process.getInputStream(), "OUTPUT");
			outputGobbler.start();
			 process.waitFor(); 
			 
			 outputGobbler = null;

			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	
	/**
	 * 读取源视频信息格式
	 * @param inputfile
	 * @return
	 */
	public static synchronized MediaInfoSO getMediaInfo(String inputfile){
		
		MediaInfoSO mi = new MediaInfoSO();
		
		//从processMedia读取获取内容
		String info = processMedia(inputfile);
		if("".equals(info)) return mi;
		
		PatternCompiler compiler =new Perl5Compiler(); 
		try {  
			//Duration: 00:24:01.49, start: 0.000000, bitrate: 1225 kb/s
	        String regexDuration ="Duration: (.*?), start: (.*?), bitrate: (\\d*) kb\\/s";  
	        //Video: rv40, yuv420p, 720x576, SAR 1:1 DAR 5:4, 25 tbr, 1k tbn, 1k tbc (default)
	       
	        // Stream #0:1(chi): Audio: cook, 44100 Hz, stereo, flt (default)
	        // Stream #0:2(eng): Audio: mp2, 48000 Hz, stereo, s16, 224 kb/s
	        String regexAudio ="Audio: (\\w*), (\\d*) Hz";  
	        //At least one output file must be specified
	        //时长正则
	        Pattern patternDuration = compiler.compile(regexDuration,Perl5Compiler.CASE_INSENSITIVE_MASK);  
	        PatternMatcher matcherDuration = new Perl5Matcher();  
	        if(matcherDuration.contains(info, patternDuration)){  
	            MatchResult re = matcherDuration.getMatch();  
	            System.out.println("提取时长字符  ===" +re.group(1));  
	            mi.setDuration(CommonUtil.Duration2long(re.group(1)));
	            System.out.println("提取出时长数字  ===" +mi.getDuration());  
	            mi.setStartTime(re.group(2));
	            System.out.println("开始时间        =====" +mi.getStartTime());
	            mi.setBitrate(CommonUtil.str2long(re.group(3)));
	            System.out.println("bitrate 码率 单位 kb==" +mi.getBitrate());  
	        }  
	        //视频正则 
	        //Stream #0:0(eng): Video: mpeg4 (Simple Profile) (mp4v / 0x7634706D), yuv420p, 640x480 [SAR 1:1 DAR 4:3], 1151 kb/s, 25 fps, 25 tbr, 90k tbn, 25 tbc    Metadata:      creation_time   : 2012-04-20 07:17:40     
	        String regexVideo ="Video: (.*?), (.*?), (.*?)[,\\s]";  
	        Pattern patternVideo = compiler.compile(regexVideo,Perl5Compiler.CASE_INSENSITIVE_MASK);  
	        PatternMatcher matcherVideo = new Perl5Matcher();  
	         
	        if(matcherVideo.contains(info, patternVideo)){  
	            MatchResult re = matcherVideo.getMatch(); 
	            System.out.println("编码格式 ===" +re.group(1)); 
	            mi.setVideoFormat(re.group(2));
	            System.out.println("视频格式===" +mi.getVideoFormat());
	            System.out.println(" 分辨率===" +re.group(3));  
	            mi.setVideoWidth(CommonUtil.getVideoMesh(re.group(3),0,640l));
	            mi.setVideoHeight(CommonUtil.getVideoMesh(re.group(3),1,480l));
	            System.out.println(" 分辨率-宽===" +mi.getVideoWidth());  
	            System.out.println(" 分辨率-高===" +mi.getVideoHeight());  
	        }  
	        //音频正则 
	        Pattern patternAudio = compiler.compile(regexAudio,Perl5Compiler.CASE_INSENSITIVE_MASK);  
	        PatternMatcher matcherAudio = new Perl5Matcher();  
	        // Stream #0:1(chi): Audio: cook, 44100 Hz, stereo, flt (default)
	        if(matcherAudio.contains(info, patternAudio)){  
	            MatchResult re = matcherAudio.getMatch();  
	            mi.setAudioFormat(re.group(1));
	            //System.out.println("音频编码  ===" +mi.getAudioFormat());
	            mi.setAudioBitRate(CommonUtil.getAudioHZ(re.group(2)));
	            //System.out.println("音频采样频率 ===" +mi.getAudioBitRate());
	        }  
	  
	    } catch (MalformedPatternException e) {  
	        e.printStackTrace();  
	    } catch (Exception e){
	    	e.printStackTrace();
	    }
		return mi;
	}
	
	/**
	 * 通过ffmpeg命令查看inputpath媒体信息
	 * @param inputPath
	 * @return
	 */
    private static String processMedia(String inputPath) {  
    	//生成转换命令
        List<String> commend=new java.util.ArrayList<String>();
		commend.add(EnvProperUtil.getFFmpegUrl());
        commend.add("-i");  
        commend.add(inputPath); 
        
        logger.info(commend.toString());
        try {  
            ProcessBuilder builder = new ProcessBuilder();  
            builder.command(commend);  
            builder.redirectErrorStream(true);  
            Process p= builder.start();  
  
           //1. start  
            BufferedReader buf = null; // 保存ffmpeg的输出结果流  
            String line = null;  
          //read the standard output  
            buf = new BufferedReader(new InputStreamReader(p.getInputStream()));  
             
            StringBuffer sb= new StringBuffer();  
            while ((line = buf.readLine()) != null) {  
	             sb.append(line);  
	             continue;  
            }  
            p.waitFor();//这里线程阻塞，将等待外部转换进程运行成功运行结束后，才往下执行
            
            //System.out.println(sb.toString());
            
            return sb.toString();  
        } catch (Exception e) {  
        	e.printStackTrace();
        } 
		
		
		return "";
    }
}
