package edu.minilive.wedu.util;

import java.util.ArrayList;
import java.util.List;

import edu.minilive.wedu.entity.BaseEntity;
import edu.minilive.wedu.module.SO.ConvertStateSO;
import edu.minilive.wedu.module.SO.LabelValueSO;




/**
 * 实体类型转换器
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-11-19 上午10:33:46
 */
public class EntityConstant {
	/**单位类型**/
	static List<LabelValueSO> companyList = null;
	
	
	/**
	 * 获取机构类型
	 * <option value="1">教育</option>
    <option value="2">金融</option>
    <option value="3">医疗</option>
    <option value="4">会计</option>
    <option value="5">法律</option>
    <option value="6">美容</option>
    <option value="7">婚庆</option>
	<option value="8">其它</option>
	 * @return
	 */
	public static List<LabelValueSO> getCompanyTypeList(){
		if(companyList==null){
			companyList = new ArrayList<LabelValueSO>();
			companyList.add(new LabelValueSO("教育", 1));
			companyList.add(new LabelValueSO("金融", 2));
			companyList.add(new LabelValueSO("医疗", 3));
			companyList.add(new LabelValueSO("会计", 4));
			companyList.add(new LabelValueSO("法律", 5));
			companyList.add(new LabelValueSO("美容", 6));
			companyList.add(new LabelValueSO("婚庆", 7));
			companyList.add(new LabelValueSO("其它", 8));
		}
		
		
		return companyList;
	}
	
	public static String getCompanyType(int type){
		for(LabelValueSO lv : getCompanyTypeList()){
			if(lv.getValue().equals(type)){
				return lv.getLabel();
			}
		}
		
		return "";
	}
	
	public static int getCompanyTypeValue(String typelabel){
		for(LabelValueSO lv : getCompanyTypeList()){
			if(lv.getLabel().equals(typelabel)){
				return (Integer) lv.getValue();
			}
		}
		
		return 0;
	}
	
	
	
	/**单位类型**/
	static List<LabelValueSO> videoSubjectList = null;
	
	/**
	 * 获取Video与FocusAd的subject列表
	 * @return
	 */
	public static List<LabelValueSO> getSubjectList(){
		if(videoSubjectList==null){
			videoSubjectList = new ArrayList<LabelValueSO>();
			videoSubjectList.add(new LabelValueSO("新闻类", 9000));
			videoSubjectList.add(new LabelValueSO("课程类", 9001));
			videoSubjectList.add(new LabelValueSO("娱乐类", 9002));
			videoSubjectList.add(new LabelValueSO("活动类", 9003));
			videoSubjectList.add(new LabelValueSO("课外类", 9004));
			videoSubjectList.add(new LabelValueSO("节目类", 9005));
			videoSubjectList.add(new LabelValueSO("宣传片", 9006));
		}
		
		return videoSubjectList;
	}
	/**
	 * 根据视频类型
	 * @param subject
	 * @return
	 */
	public static String getVideoSubjectType(int subject){
		for(LabelValueSO lv : getSubjectList()){
			if(lv.getValue().equals(subject)){
				return lv.getLabel();
			}
		}
		
		return "其他类";
	}
	
	public static String getVideoState(int state){
		if(state==ConvertStateSO.CONVERTING){
			return "正在转换";
		}else if(state==ConvertStateSO.SUCCESS){
			return "正常";
		}else if(state==ConvertStateSO.FAIL){
			return "转换失败";
		}else if(state==ConvertStateSO.RESTOREMETADATA_FAIL){
			return "修复Metadata失败";
		}else if(state==ConvertStateSO.SCREENSHOT_FAIL){
			return "截图失败";
		}else if(state==ConvertStateSO.SOUREFILE_NOTEXISTS){
			return "源文件不存在";
		}else if(state==3){
			return "等待审核";
		}
		
		
		return "新视频";
	}
	
	
	
	
	/**
	 * 根据用户查询性别
	 * @param sex
	 * @return
	 */
	public static String getUserSex(int sex){
		if(sex==0){
			return "保密";
		}else if(sex==1){
			return "男";
		}else if(sex==2){
			return "女";
		}
		
		return "";
	}
	
	/**
	 * 读取企业单位验证状态文字说明
	 * @param vertystate
	 * @return
	 */
	public static String getCompanyVertystate(int vertystate){
		if(vertystate==0){
			return "待验证 ";
		}else if(vertystate==1){
			return "验证通过 ";
		}else if(vertystate==2){
			return "验证中";
		}else if(vertystate==3){
			return "验证驳回";
		}
		
		return "";
	}
	
	/**
	 * 1-图文	2-视频||适用于花瓣分类（活动分类 ）频道<p>
	 * 10-园长  	11-教师 	12-园所||适用于推荐频道<p>
	 * @param classify
	 * @return
	 */
	public static String getClassify(int classify, String dv){
		if(classify==1){
			return "图文";
		}else if(classify==2){
			return "视频";
		}else if(classify==10){
			return "园长";
		}else if(classify==11){
			return "教师";
		}else if(classify==12){
			return "园所";
		}
		
		return dv;
	}
	
	/**
	 * 根据形式返回说明
	 * 1-歌曲	2-舞蹈	3-课间游戏	4-亲子游戏	5-其他
	 * @param shape
	 * @return
	 */
	public static String getShape(int shape, String dv){
		if(shape==1){
			return "图文";
		}else if(shape==2){
			return "舞蹈";
		}else if(shape==3){
			return "课间游戏";
		}else if(shape==4){
			return "亲子游戏";
		}else if(shape==5){
			return "其他";
		}
		
		return dv;
	}
	
	/**
	 * 根据学龄返回说明
	 * 1-托班	2-小班	3-中班	4-大班
	 * @param schoolage
	 * @param dv
	 * @return
	 */
	public static String getSchoolage(int schoolage, String dv){
		if(schoolage==1){
			return "托班";
		}else if(schoolage==2){
			return "小班";
		}else if(schoolage==3){
			return "中班";
		}else if(schoolage==4){
			return "大班";
		}
		
		return dv;
	}
	
	/**
	 * 根据种类返回说明
	 * 1-角色	2-结构	3-表演	4-智力	5-体育	6-音乐
	 * @param hdtype
	 * @param dv
	 * @return
	 */
	public static String getHdtype(int hdtype, String dv){
		if(hdtype==1){
			return "角色";
		}else if(hdtype==2){
			return "结构";
		}else if(hdtype==3){
			return "表演";
		}else if(hdtype==4){
			return "智力";
		}else if(hdtype==5){
			return "体育";
		}else if(hdtype==6){
			return "音乐";
		}
		
		return dv;
	}
	
	/**
	 * 根据文章操作类型，返回文字说明
	 * @param optType
	 * @return
	 */
	public static String getOptType(int optType, String dv){
		if(optType==1){
			return "赞";
		}else if(optType==2){
			return "踩";
		}
		
		return dv;
	}
	
	/**
	 * 判断两实体ID是否相同
	 * @param entiry1
	 * @param entiry2
	 * @return
	 */
	public static boolean isequals(BaseEntity entiry1, BaseEntity entiry2){
		try{
			return entiry1!=null && entiry2!=null && entiry1.getId().equals(entiry2.getId());
		}catch(Exception e){
			e.printStackTrace();
		}
		
		return false;
	}
	
	/**
	 * 判断两实体ID是否相同
	 * @param entiry1
	 * @param entiry2
	 * @return
	 */
	public static boolean isequals(Long id, Long id2){
		return id!=null && id2!=null && id.equals(id2);
	}
}
