package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.WeiWishesDAO;
import edu.minilive.wedu.entity.app.WeiWishes;
import edu.minilive.wedu.service.WeiWishesService;


/**
 * 《微遗愿》	服务层实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:22:27
 */
@Service("weiWishesService")
public class WeiWishesServiceImpl extends GenerateService implements
		WeiWishesService {

	@Autowired
	WeiWishesDAO weiWishesDAO;
	
	@Override
	public WeiWishes addWeiWishes(WeiWishes weiWishes) {
		weiWishesDAO.create(weiWishes);
		return weiWishes;
	}

	@CacheEvict(value="default",key="'WeiWishes-cache-by' + #weiWishes.id")
	@Override
	public void updateWeiWishes(WeiWishes weiWishes) {
		weiWishesDAO.update(weiWishes);
	}

	@Cacheable(value="default",key="'WeiWishes-cache-by' + #id")
	@Override
	public WeiWishes getWeiWishesById(Long id) {
		return weiWishesDAO.query(id);
	}

	@Cacheable(value="default",key="'WeiWishesList-cache-byopenId-' + #openId")
	@Override
	public List<WeiWishes> getWeiWishesList(String openId) {
		if(openId==null || "".equals(openId)){
			return Collections.emptyList(); 
		}
		
		return weiWishesDAO.queryWeiWishesList(openId);
	}

	@Override
	public List<WeiWishes> getWeiWishesListBymsgId(String msgId) {
		if(msgId==null || "".equals(msgId)){
			return Collections.emptyList(); 
		}
		
		
		return weiWishesDAO.queryWeiWishesListBymsgId(msgId);
	}

}
