package edu.minilive.wedu.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.app.WeiVoteDAO;
import edu.minilive.wedu.dao.app.WeiVoteItemDAO;
import edu.minilive.wedu.dao.app.WeiVoteItemRecDAO;
import edu.minilive.wedu.entity.app.WeiVote;
import edu.minilive.wedu.entity.app.WeiVoteItem;
import edu.minilive.wedu.entity.app.WeiVoteItemRec;
import edu.minilive.wedu.service.WeiVoteService;
/**
 * 微投票（微应用） 服务层接口实现 
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午11:21:36
 */
@Service("weivoteService")
public class WeiVoteServiceImpl extends GenerateService implements
		WeiVoteService {
	
	@Autowired
	WeiVoteDAO weiVoteDAO;
	
	@Autowired
	WeiVoteItemDAO weiVoteItemDAO;
	
	@Autowired
	WeiVoteItemRecDAO weiVoteItemRecDAO;
	
	@Override
	public WeiVote addWeiVote(WeiVote weiVote) {
		weiVoteDAO.create(weiVote);
		return weiVote;
	}

	@Override
	public void updateWeiVote(WeiVote weiVote) {
		weiVoteDAO.update(weiVote);
	}

	@Override
	public WeiVote getWeiVote(Long id) {
		return weiVoteDAO.query(id);
	}

	@Override
	public WeiVoteItem addWeiVoteItem(WeiVoteItem weiVoteItem) {
		weiVoteItemDAO.create(weiVoteItem);
		return weiVoteItem;
	}

	@Override
	public void updateWeiVoteItem(WeiVoteItem weiVoteItem) {
		weiVoteItemDAO.update(weiVoteItem);
	}

	@Override
	public WeiVoteItem getWeiVoteItem(Long id) {
		return weiVoteItemDAO.query(id);
	}

	@Override
	public List<WeiVote> getVoteList(Long schoolId, String keyword, int state,
			Page page) {
		return weiVoteDAO.queryVoteList(schoolId, keyword, state, page);
	}

	
	@Override
	public List<WeiVote> getVoteBySchoolId(Long schoolId) {
		return weiVoteDAO.queryVoteBySchoolId(schoolId);
	}

	@Override
	public List<WeiVoteItem> getWeiVoteItemListByVoteId(Long voteId) {
		return weiVoteItemDAO.queryVoteItemByVote(voteId);
	}

	@Override
	public Long countVoteItem(Long voteId) {
		if(voteId>0){
			return weiVoteItemRecDAO.countVoteItem(voteId);
		}
		
		return 0l;
	}

	@Override
	public WeiVoteItemRec addWeiVoteItemRec(WeiVoteItemRec weiVoteItemRec) {
		weiVoteItemRecDAO.create(weiVoteItemRec);
		return weiVoteItemRec;
	}


}
