package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.WeiAlbumDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.CompanyApp;
import edu.minilive.wedu.entity.app.WeiAlbum;
import edu.minilive.wedu.service.WeiAlbumService;

/**
 * <b>微相册</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:32:13
 */
@Service("weiAlbumService")
public class WeiAlbumServiceImpl extends GenerateService implements
		WeiAlbumService {
	
	@Autowired
	WeiAlbumDAO weiAlbumDAO;
	
	
	
	@Override
	public WeiAlbum addWeiAlbum(WeiAlbum weiAlbum) {
		weiAlbumDAO.create(weiAlbum);
		return weiAlbum;
	}

	@CacheEvict(value="default",key="'WeiAlbum-cache-by' + #weiAlbum.id")
	@Override
	public WeiAlbum editWeiAlbum(WeiAlbum weiAlbum) {
		weiAlbumDAO.update(weiAlbum);
		return weiAlbum;
	}

	@Cacheable(value="default",key="'WeiAlbum-cache-by' + #id")
	@Override
	public WeiAlbum getWeiAlbumById(Long id) {
		return weiAlbumDAO.query(id);
	}

	@Override
	public WeiAlbum delWeiAlbum(WeiAlbum weiAlbum) {
		if(weiAlbum==null) return null;
		// TODO 删除相册时，删除相册下的所有照片，并重置相册数量为0
		
		
		weiAlbum.setState(2);
		editWeiAlbum(weiAlbum);
		
		return weiAlbum;
	}

	@Override
	public List<WeiAlbum> getWeiAlbumListByCompany(Company school,
			String title, CompanyApp companyApp, Page page) {
		if(school==null){
			return Collections.emptyList(); 
		}
		
		
		return weiAlbumDAO.queryWeiAlbumListByCompany(school, title, companyApp, page);
	}

}
