package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.app.WeiActvityApplyDAO;
import edu.minilive.wedu.dao.app.WeiActvityDAO;
import edu.minilive.wedu.entity.app.WeiActvity;
import edu.minilive.wedu.entity.app.WeiActvityApply;
import edu.minilive.wedu.service.WeiActvityService;
/**
 * 微活动（微应用） 服务层接口实现 
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午11:21:36
 */
@Service("weiActvityService")
public class WeiActvityServiceImpl extends GenerateService implements
		WeiActvityService {
	
	@Autowired
	WeiActvityDAO weiActvityDAO;
	
	@Autowired
	WeiActvityApplyDAO weiActvityApplyDAO;

	@Override
	public WeiActvity addWeiActvity(WeiActvity weiActvity) {
		weiActvityDAO.create(weiActvity);
		return weiActvity;
	}

	@Override
	public WeiActvity getWeiActvity(Long id) {
		return weiActvityDAO.query(id);
	}
	
	@CacheEvict(value="default",key="'WeiActvitybyID_' + #weiActvity.id")
	@Override
	public void updateWeiActvity(WeiActvity weiActvity) {
		weiActvityDAO.update(weiActvity);
	}

	@Cacheable(value="default",key="'WeiActvitybyID_' + #id")
	@Override
	public WeiActvity getWeiActvityById(Long id) {
		WeiActvity activity = weiActvityDAO.query(id);
		
		return activity;
	}

	@Override
	public List<WeiActvity> getActvityBySchoolId(Long schoolId) {
		return weiActvityDAO.queryActvityBySchoolId(schoolId);
	}

	@Override
	public List<WeiActvity> getActvityBySchoolId(Long schoolId, String keyword,
			int state, Page page) {
		if(schoolId!=null && schoolId>0){
			return weiActvityDAO.queryActvityBySchoolId(schoolId, keyword, state, page);
		}
		
		return Collections.emptyList();
	}

	
	
	@Override
	public WeiActvityApply getWeiActvityApply(Long id) {
		return weiActvityApplyDAO.query(id);
	}

	@Cacheable(value="default",key="'WeiActvityApplybyID_' + #id")
	@Override
	public WeiActvityApply getWeiActvityApplyById(Long id) {
		return weiActvityApplyDAO.query(id);
	}
	
	@Override
	public WeiActvityApply addWeiActvityApply(WeiActvityApply weiActvityApply) {
		weiActvityApplyDAO.create(weiActvityApply);
		return weiActvityApply;
	}

	@CacheEvict(value="default",key="'WeiActvityApplybyID_' + #id")
	@Override
	public void updateWeiActvityApply(WeiActvityApply weiActvityApply) {
		weiActvityApplyDAO.update(weiActvityApply);
	}

	@Override
	public List<WeiActvityApply> getWeiActvityApplyList(Long actvityId, int state) {
		if(actvityId!=null && actvityId>0){
			return weiActvityApplyDAO.queryWeiActvityApply(actvityId, null, state);
		}
		
		return Collections.emptyList();
	}

	@Override
	public List<WeiActvityApply> getWeiActvityApplyList(Long userId, int state,
			Page page) {
		if(userId!=null && userId>0){
			return weiActvityApplyDAO.queryWeiActvityApply(userId, state, page);
		}
		
		return Collections.emptyList();
	}

	@Override
	public WeiActvityApply getWeiActvityApply(Long actvityId, Long userId) {
		
		List<WeiActvityApply> list = weiActvityApplyDAO.queryWeiActvityApply(actvityId, userId, -2);
		if(list!=null && list.size()>0){
			return list.get(0);
		}
		
		return null;
	}

	

	
}
