package edu.minilive.wedu.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.WXMessagesDAO;
import edu.minilive.wedu.entity.app.WXMessages;
import edu.minilive.wedu.service.WXMessagesService;
/**
 * 历史消息服务层
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:22:27
 */
@Service("wxMessagesService")
public class WXMessagesServiceImpl extends GenerateService implements
		WXMessagesService {
	
	@Autowired
	WXMessagesDAO wxMessagesDAO;
	
	@Cacheable(value="default",key="'WXMessages-cache-by' + #id")
	@Override
	public WXMessages getWXMessagesById(Long id) {
		return wxMessagesDAO.query(id);
	}

	@CacheEvict(value="default",key="'WXMessages-cache-by' + #wxmessage.id")
	@Override
	public void deleteWXMessages(WXMessages wxmessage) {
		wxMessagesDAO.delete(wxmessage);
	}

	@Override
	public WXMessages createWXMessages(WXMessages wxMessages) {
		wxMessagesDAO.create(wxMessages);
		return wxMessages;
	}
	
	

}
