package edu.minilive.wedu.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.UserDAO;
import edu.minilive.wedu.entity.User;
import edu.minilive.wedu.service.UserService;

/**
 * <b>用户</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-2-24 下午2:16:07
 */
@Service("userService")
public class UserServiceImpl extends GenerateService implements UserService {

	/**
	 * CAS||学校-DAO
	 */
	@Autowired
	UserDAO userDAO;

	@Override
	public void creatUser(User user) {
		if (user != null) {
			this.userDAO.create(user);
		}
	}
	
	@Cacheable(value="default",key="'usercachebykey_' + #userName")
	@Override
	public User getUserByUserName(String userName) {
		if (userName != null && !"".equals(userName)) {
			return userDAO.getUser(userName);
		}
		return null;
	}
	
	@Override
	public User getUserByUserNameNoCache(String userName) {
		if (userName != null && !"".equals(userName)) {
			return userDAO.getUser(userName);
		}
		return null;
	}

	
	@Cacheable(value="default",key="'usercachebykey_' + #userId")
	@Override
	public User getUserByUserId(Long userId) {
		if (userId != null) {
			return userDAO.queryUserById(userId);
		}
		return null;
	}

	@Override
	public List<User> getUserList(String username, int enable, Page page) {
		return userDAO.queryUserList(username, enable, null, null, page);
	}

	@CacheEvict(value="default",key="'usercachebykey_' + #user.id")
	@Override
	public void updateUser(User user) {
		userDAO.update(user);
	}

	@Override
	public User getUserByQQ(String qqId) {
		return userDAO.queryUserByQQ(qqId);
	}


}
