package edu.minilive.wedu.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.UserAppDAO;
import edu.minilive.wedu.entity.UserApp;
import edu.minilive.wedu.service.UserAppService;

/**
 * <b>个人应用</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 下午3:57:55
 */
@Service("userAppService")
public class UserAppServiceImpl extends GenerateService implements
		UserAppService {
	
	@Autowired
	UserAppDAO userAppDAO;
	
	@Override
	public UserApp getUserAppById(Long id) {
		return userAppDAO.query(id);
	}

	@Override
	public UserApp getUserApp(Long id) {
		return userAppDAO.query(id);
	}

	@Override
	public UserApp addUserApp(UserApp userApp) {
		userAppDAO.create(userApp);
		return userApp;
	}

	@Override
	public void updateUserApp(UserApp userApp) {
		userAppDAO.update(userApp);
	}

	@Override
	public List<UserApp> getUserAppList(Long userId) {
		return userAppDAO.queryUserApp(userId, null);
	}

}
