package edu.minilive.wedu.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.CompanyDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.District;
import edu.minilive.wedu.service.CompanyService;

/**
 * <b>学校</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 下午3:57:55
 */
@Service("companyService")
public class CompanyServiceImpl extends GenerateService implements CompanyService {
	
	/**
	 * CAS||学校-DAO
	 */
	@Autowired
	private CompanyDAO companyDAO;
	
	
	@Override
	public List<Company> getCompanyList() {
		return companyDAO.queryCompanyList();
	}

	@Override
	public void creatCompany(Company company) {
		if (company != null) {
			companyDAO.create(company);
		}
	}

	@Cacheable(value="default",key="'company-cache-by' + #companyId")
	@Override
	public Company getCompany(Long companyId) {
		if (companyId!= null && companyId > 0) {
			return companyDAO.query(companyId);
		}
		return null;
	}

	@CacheEvict(value="default",key="'company-cache-by' + #company.id")
	@Override
	public void updateCompany(Company company) {
		if (company != null) {
			companyDAO.update(company);
		}
	}


	@Override
	public List<Company> getCompanyListByKey(String companyName, int status,
			Long provinceId, Long cityId, Long areaId) {
		return companyDAO.queryCompanyListByKey(companyName, status, provinceId, cityId, areaId);
	}

	@Override
	public Company getCompanyByName(String companyName, Long provinceId,
			Long cityId, Long areaId) {
		if(companyName!=null && !"".equals(companyName)){
			List<Company> list = getCompanyListByKey(companyName, 1,provinceId,cityId,areaId);
			if(list.size()>0){
				return list.get(0);
			}
		}
		
		
		return null;
	}

	@Override
	public List<Company> getCompanyListBySystem(String keyword, int type,
			int subtype, int status, District province, District city,
			int vertystate, Page page) {
		return companyDAO.queryCompanyListBySystem(keyword, type, subtype, status,province, city,vertystate, page);
	}

}

