package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.CompanyAppDAO;
import edu.minilive.wedu.entity.App;
import edu.minilive.wedu.entity.CompanyApp;
import edu.minilive.wedu.service.CompanyAppService;

/**
 * <b>单位应用</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-2-25 上午10:46:45
 */
@Service("companyAppService")
public class CompanyAppServiceImpl extends GenerateService implements
		CompanyAppService {
	
	@Autowired
	CompanyAppDAO companyAppDAO;

	
	@Override
	public CompanyApp createCompanyApp(CompanyApp companyApp) {
		companyAppDAO.create(companyApp);
		return companyApp;
	}

	@Override
	public void updateCompanyApp(CompanyApp companyApp) {
		companyAppDAO.update(companyApp);
	}
	
	@Override
	public List<CompanyApp> getCompanyAppList(Long schoolId,String appalias, App app,  int apptype,int state, int showApp) {
		if(schoolId==null){
			return Collections.emptyList();
		}
		return companyAppDAO.queryCompanyApp(schoolId,appalias,app, apptype, state, showApp);
	}

	@Override
	public CompanyApp getCompanyApp(Long schoolId, String appalias) {
		List<CompanyApp> list = getCompanyAppList(schoolId,appalias,null,-1,1,-1);
		if(list.size()>0){
			return list.get(0);
		}
		
		return null;
	}

	@Override
	public CompanyApp getCompanyAppById(Long id) {
		return companyAppDAO.query(id);
	}

	@Cacheable(value="default",key="'CompanyAppListbyschool_' + #school")
	@Override
	public List<CompanyApp> getCompanyAppList(Long school) {
		if(school==null || school==0l){
			return Collections.emptyList();
		}
		return companyAppDAO.queryCompanyApp(school,null,null, -1, 1, -1);
	}

	@CacheEvict(value="default",key="'CompanyAppListbyschool_' + #school")
	@Override
	public void clearCompanyAppListCache(Long school) {
		// TODO 清除校园微信应用缓存
		
	}

	

}
