package edu.minilive.wedu.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.ChannelDAO;
import edu.minilive.wedu.entity.Channel;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.service.ChannelService;

/**
 * <b>栏目、频道</b> 服务层接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-2-25 上午10:46:45
 */
@Service("channelService")
public class ChannelServiceImpl extends GenerateService implements
		ChannelService {
	
	@Autowired
	ChannelDAO channelDAO;
	
	@Override
	public Channel addChannel(Channel post) {
		if(post!=null){
			channelDAO.create(post);
		}
		
		return post;
	}
	
	@Override
	public Channel getChannel(Long id) {
		return channelDAO.query(id);
	}
	
	@Cacheable(value="default",key="'channel-cache-by' + #id")
	@Override
	public Channel getChannelById(Long id) {
		Channel c = channelDAO.query(id);
		List<Channel> list = getChannelListByParent(c);
		c.setSubChannelList(list);
		return c;
	}
	
	@Cacheable(value="default",key="'channel-cache-byalias' + #id")
	@Override
	public Channel getChannelByAlias(String alias) {
		return channelDAO.queryChannelByAlias(alias);
	}
	
	@CacheEvict(value="default",key="'channel-cache-by' + #channel.id")
	@Override
	public Channel updateChannel(Channel channel) {
		channelDAO.update(channel);
		return channel;
	}

	@Cacheable(value="default",key="'channel-cache-byparent' + #channel.id")
	@Override
	public List<Channel> getChannelListByParent(Channel channel) {
		if(channel==null){
			return Collections.emptyList();
		}
		return channelDAO.queryChannelListByParent(channel);
	}

	@CacheEvict(value="default",key="'channel-cache-byparent' + #channel.id")
	@Override
	public void clearChannelListByParentCache(Channel channel) {
		// TODO 清除getChannelListByParent缓存
	}

	@Cacheable(value="default",key="'firstchannel-cache'")
	@Override
	public List<Channel> getChannelList() {
		return channelDAO.queryChannelList();
	}
	
	@Override
	public List<Channel> getChannelByCompany(Company company, Channel parentChannel, Page page) {
		return channelDAO.queryChannelByCompany(company, parentChannel, page);
	}

	@CacheEvict(value="default",key="'allchannel-cache-byschool' + #schoolId")
	@Override
	public void clearAllChannelByCompanyCache(Long schoolId) {
		// TODO Auto-generated method stub
	}
	
	

	@Cacheable(value="default",key="'allchannel-cache-byschool' + #company.id")
	@Override
	public List<Channel> getAllChannelByCompany(Company company) {
		return channelDAO.queryAllChannelByCompany(company);
	}

	

	

	
}
