package edu.minilive.wedu.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.core.service.GenerateService;
import edu.minilive.wedu.dao.AppDAO;
import edu.minilive.wedu.entity.App;
import edu.minilive.wedu.service.AppService;

/**
 * 微应用服务层
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:22:27
 */
@Service("appService")
public class AppServiceImpl extends GenerateService implements AppService {
	
	@Autowired
	AppDAO appDAO;

	@Override
	public App addApp(App app) {
		appDAO.create(app);
		return  app;
	}

	@Cacheable(value="default",key="'app-cache-by' + #id")
	@Override
	public App getAppById(Long id) {
		return appDAO.query(id);
	}

	@CacheEvict(value="default",key="'app-cache-by' + #app.id")
	@Override
	public App updateApp(App app) {
		appDAO.update(app);
		return app;
	}

	@Cacheable(value="default",key="'app-cache-byalias' + #alias")
	@Override
	public App getAppByAlias(String alias) {
		return appDAO.queryAppByAlias(alias);
	}

	@Override
	public List<App> getAppsByUser() {
		return appDAO.queryAppsByUser();
	}
	
}
