package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.app.WeiXiTie;
import edu.minilive.wedu.entity.app.WeiXiTieBlessing;


/**
 * 微喜帖（微应用） 接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-12-9 下午3:17:50
 */
@Transactional
public interface WeiXiTieService {
	/**
	 * 根据ID查询喜帖
	 * @param id
	 * @return
	 */
	WeiXiTie getWeiXiTieById(Long id);
	/**
	 * 根据Token查询喜帖
	 * @param token
	 * @return
	 */
	WeiXiTie getWeiXiTieByToken(String token);
	
	/**
	 * 发起新祝福
	 * @param weiXiTieBlessing
	 * @return
	 */
	WeiXiTieBlessing createNewWeiXiTieBlessing(WeiXiTieBlessing weiXiTieBlessing);
	
	/**
	 * 根据单位查询喜帖列表
	 * @param company
	 * @param page
	 * @return
	 */
	List<WeiXiTie> getWeiXiTieByCompany(Company company, Page page);
}
