package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.minilive.wedu.entity.app.WeiWishes;


/**
 * 《微心愿》	服务层定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-8 下午3:30:37
 */
@Transactional
public interface WeiWishesService {
	/**
	 * 添加心愿
	 * @param weiWishes
	 * @return
	 */
	WeiWishes addWeiWishes(WeiWishes weiWishes);
	
	/**
	 * 修改心愿（删除）
	 * @param weiWishes
	 */
	void updateWeiWishes(WeiWishes weiWishes);
	
	/**
	 * 根据ID查询心愿
	 * @param id
	 * @return
	 */
	WeiWishes getWeiWishesById(Long id);
	
	/**
	 * 获取OpenId的心愿列表
	 * @param openId
	 * @return
	 */
	List<WeiWishes> getWeiWishesList(String openId);
	
	/**
	 * 获取msgId的心愿列表
	 * @param msgId
	 * @return
	 */
	List<WeiWishes> getWeiWishesListBymsgId(String msgId);
}
