package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.app.WeiVote;
import edu.minilive.wedu.entity.app.WeiVoteItem;
import edu.minilive.wedu.entity.app.WeiVoteItemRec;
/**
 * 微投票（微应用） 接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午10:56:48
 */
@Transactional
public interface WeiVoteService {
	/**
	 * 添加微投票
	 * @param weiVote
	 * @return
	 */
	WeiVote addWeiVote(WeiVote weiVote);
	
	/**
	 * 更新微投票内容
	 * @param weiVote
	 */
	void updateWeiVote(WeiVote weiVote);
	
	/**
	 * 根据Id查询WeiVote
	 * @param id
	 * @return
	 */
	WeiVote getWeiVote(Long id);
	
	/**
	 * 添加投票项
	 * @param weiVoteItem
	 * @return
	 */
	WeiVoteItem addWeiVoteItem(WeiVoteItem weiVoteItem);
	
	/**
	 * 修改投票项
	 * @param weiVoteItem
	 * @return
	 */
	void updateWeiVoteItem(WeiVoteItem weiVoteItem);
	
	/**
	 * 根据Id查询投票项
	 * @param weiVoteItem
	 * @return
	 */
	WeiVoteItem getWeiVoteItem(Long id);
	
	/**
	 * 根据投票编号
	 * @param id
	 * @return
	 */
	List<WeiVoteItem> getWeiVoteItemListByVoteId(Long voteId);
	
	/**
	 * 根据学校Id查询投票
	 * @param schoolId		学校ID
	 * @return
	 */
	List<WeiVote> getVoteBySchoolId(Long schoolId);
	
	/**
	 * 查询学校投票列表
	 * @param schoolId
	 * @param keyword
	 * @param state
	 * @param page
	 * @return
	 */
	List<WeiVote> getVoteList(Long schoolId, String keyword, int state, Page page);
	
	/**
	 * 统计投票总数
	 * @param voteId
	 * @return
	 */
	Long countVoteItem(Long voteId);
	
	/**
	 * 添加投票
	 * @param weiVoteItemRec
	 * @return
	 */
	WeiVoteItemRec addWeiVoteItemRec(WeiVoteItemRec weiVoteItemRec);
}
