package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;
import edu.minilive.wedu.entity.app.WeiVideo;
import edu.minilive.wedu.entity.app.WeiVideoConfig;

/**
 * <b>教育微频-微应用</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-2-24 下午2:15:44
 */
@Transactional
public interface WeiVideoService {
	/**
	 * 新增视频
	 * @param weiVideo
	 * @return
	 */
	WeiVideo createWeiVideo(WeiVideo weiVideo);
	/**
	 * 更新视频
	 * @param weiVideo
	 */
	void  updateWeiVideo(WeiVideo weiVideo);
	
	/**
	 * 删除视频
	 * @param WeiVideo
	 */
	void deleteWeiVideo(WeiVideo weiVideo);
	
	/**
	 * 根据ID查询视频
	 * @param id
	 * @return
	 */
	WeiVideo getWeiVideoById(Long id);
	
	/**
	 * 查询单位所有有效的视频
	 * <li>条件：status=1
	 * <li>Order: istop, updataDate desc, uploadDate desc 
	 * @param company	单位实体
	 * @return
	 */
	List<WeiVideo> getCompanyVideo(Company company, Page page);
	
	/**
	 * 仅仅更新视频状态
	 * 
	 * @param videoId
	 * @param status	@see ConvertState
	 */
	public void updateVideoStatus(Long videoId, int status);
	
	/**
	 * 根据综合条件查询视频列表
	 * @param title			关键词（like,null或者空不为条件）
	 * @param status		状态（-1不为条件，-2除注销状态以外，具体详见Video.status)
	 * @param user			用户（null不为条件）
	 * @param company		所属单位（null不为条件）
	 * @param subject		分类（null或者空不为条件，具体详见com.eduvideo.common.bean.SubjectList)
	 * @param page			分页
	 * @return
	 */
	public List<WeiVideo> getVideoList(String title, int status, User user, Company company,int subject, Page page);
	
	/**
	 * 根据单位查询脚本
	 * @param company
	 * @return
	 */
	WeiVideoConfig getWeiVideoConfigByCompany(Company company);
	
	/**
	 * 新增配置
	 * @param weiVideo
	 * @return
	 */
	WeiVideoConfig createWeiVideoConfig(WeiVideoConfig weiVideoConfig);
	/**
	 * 更新配置
	 * @param weiVideo
	 */
	void  updateWeiVideoConfig(WeiVideoConfig weiVideoConfig);
	
	/**
	 * 删除配置
	 * @param WeiVideo
	 */
	void deleteWeiVideoConfig(WeiVideoConfig weiVideoConfig);
}
