package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.app.WeiAlbum;
import edu.minilive.wedu.entity.app.WeiPhoto;

/**
 * 微相册（微应用） 接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-12-9 下午3:17:50
 */
@Transactional
public interface WeiPhotoService {
	/**
	 * 根据ID查询Photo实体
	 * @param id
	 * @return
	 */
	WeiPhoto getPhotoById(Long id);
	
	/**
	 * 创建照片实体
	 * @param weiPhoto
	 * @return
	 */
	WeiPhoto addWeiPhoto(WeiPhoto weiPhoto);
	
	/**
	 * 更新实体
	 * @param weiPhoto
	 * @return
	 */
	void editWeiPhoto(WeiPhoto weiPhoto);
	
	/**
	 * 根据Token查询相册列表
	 * @param token
	 * @param company
	 * @param page
	 * @return
	 */
	List<WeiPhoto> getPhotoListByToken(String token, Company company, Page page);
	
	/**
	 * 根据单位或者相册查询照片列表
	 * @param title
	 * @param company
	 * @param weiAlbum
	 * @param page
	 * @return
	 */
	List<WeiPhoto> getPhotoListByCompany(String title, Company company, WeiAlbum weiAlbum, Page page  );
	
	/**
	 * 根据photoIds查询相册列表
	 * @param photoIds 照片ID(多个)
	 * @return
	 */
	List<WeiPhoto> getPhotoListByIds(String photoIds, Company company, WeiAlbum weiAlbum, Page page);
	
	/**
	 * 统计该相册的相片总数
	 * @param weiAlbum
	 * @return
	 */
	Long countAlbumPhoto(WeiAlbum weiAlbum);
}
