package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.CompanyApp;
import edu.minilive.wedu.entity.app.WeiAlbum;

/**
 * <b>微相册</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:30:06
 */
@Transactional
public interface WeiAlbumService {
	/**
	 * 新增微相册
	 * @param weiAlbum
	 * @return
	 */
	WeiAlbum addWeiAlbum(WeiAlbum weiAlbum);
	/**
	 * 编辑微相册
	 * @param weiAlbum
	 * @return
	 */
	WeiAlbum editWeiAlbum(WeiAlbum weiAlbum);
	/**
	 * 根据ID读取微相册
	 * @param id
	 * @return
	 */
	WeiAlbum getWeiAlbumById(Long id);
	/**
	 * 相册微应用，并删除相册下的所有照片
	 * @param weiAlbum
	 * @return
	 */
	WeiAlbum delWeiAlbum(WeiAlbum weiAlbum);
	
	/**
	 * 根据学校、单位查询相册【后台管理】
	 * @param school		学校、单位
	 * @param title			标题
	 * @param companyApp	所属微应用
	 * @param page			
	 * @return
	 */
	List<WeiAlbum> getWeiAlbumListByCompany(Company school, String title, 	CompanyApp companyApp, Page page);
	
	
}
