package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.app.WeiActvity;
import edu.minilive.wedu.entity.app.WeiActvityApply;

/**
 * 微活动（微应用） 接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午10:56:48
 */
@Transactional
public interface WeiActvityService {
	/**
	 * 创建活动
	 * @param weiActvity
	 * @return
	 */
	WeiActvity addWeiActvity(WeiActvity weiActvity);
	/**
	 * 更新活动内容
	 * @param weiActvity
	 */
	void updateWeiActvity(WeiActvity weiActvity);
	
	/**
	 * 根据ID查询活动（无缓存）
	 * @param id
	 * @return
	 */
	WeiActvity getWeiActvity(Long id);
	
	/**
	 * 根据ID查询活动（带缓存）
	 * @param id
	 * @return
	 */
	WeiActvity getWeiActvityById(Long id);

	/**
	 * 根据学校查询活动
	 * @param schoolId
	 * @return
	 */
	List<WeiActvity> getActvityBySchoolId(Long schoolId);
	
	/**
	 * 根据学校查询活动
	 * @param schoolId		学校编号
	 * @param keyword		活动关键词
	 * @param state			状态
	 * @param page			分页
	 * @return
	 */
	List<WeiActvity> getActvityBySchoolId(Long schoolId, String keyword, int state, Page page);
	
	
	/**
	 * 根据ID查询活动（不带缓存）
	 * @param weiActvityApply
	 * @return
	 */
	WeiActvityApply getWeiActvityApply(Long id);
	
	/**
	 * 根据ID查询活动（带缓存）
	 * @param weiActvityApply
	 * @return
	 */
	WeiActvityApply getWeiActvityApplyById(Long id);
	
	/**
	 * 参加活动
	 * @param weiActvityApply
	 * @return
	 */
	WeiActvityApply addWeiActvityApply(WeiActvityApply weiActvityApply);
	/**
	 * 更新参与信息（一般处理退出活动）
	 * @param weiActvityApply
	 */
	void updateWeiActvityApply(WeiActvityApply weiActvityApply);
	
	/**
	 * 查询活动报名列表
	 * @param actvityId
	 * @return
	 */
	List<WeiActvityApply> getWeiActvityApplyList(Long actvityId, int state);
	
	/**
	 * 查询用户活动报名列表
	 * @param userId		用户
	 * @param state			状态
	 * @param page			分页
	 * @return
	 */
	List<WeiActvityApply> getWeiActvityApplyList(Long userId, int state, Page page);
	
	/**
	 * 查询用户与活动的关系 
	 * @param actvityId
	 * @param userId
	 * @return
	 */
	WeiActvityApply getWeiActvityApply(Long actvityId, Long userId);
}
