package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.minilive.wedu.entity.UserApp;

/**
 * <b>个人用户应用</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-2-25 上午11:21:10
 */
@Transactional
public interface UserAppService {
	/**
	 * 根据ID查询用户应用（带缓存）
	 * @param id
	 * @return
	 */
	UserApp getUserAppById(Long id);
	/**
	 * 根据ID查询用户应用
	 * @param id
	 * @return
	 */
	UserApp getUserApp(Long id);
	/**
	 * 注册开通App
	 * @param userApp
	 * @return
	 */
	UserApp addUserApp(UserApp userApp);
	/**
	 * 更新App
	 * @param userApp
	 */
	void updateUserApp(UserApp userApp);
	
	/**
	 * 查询用户应用
	 * @param userId
	 * @return
	 */
	List<UserApp> getUserAppList(Long userId);
}
