package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.UpdateLog;


/**
 * 平台历史更新日志服务层
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:20:15
 */
@Transactional
public interface UpdateLogService {
	/**
	 * 根据ID读取历史更新记录
	 * @param id
	 * @return
	 */
	UpdateLog getUpdateLogById(Long id);
	
	/**
	 * 删除更新记录
	 * @param updatelog
	 */
	void deleteUpdateLog(UpdateLog updatelog);
	
	/**
	 * 更新最近更新的历史记录
	 * @param page
	 * @return
	 */
	List<UpdateLog> getUpdateLogList(Page page);
}
