package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.FocusAd;

/**
 * <b>焦点广告</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:30:06
 */
@Transactional
public interface FocusAdService {
	/**
	 * 添加实体
	 * @param fouseAd
	 * @return
	 */
	FocusAd addFocusAd(FocusAd fouseAd);
	/**
	 * 更新实体
	 * @param focusAd
	 * @return
	 */
	FocusAd updateFocusAd(FocusAd focusAd);
	/**
	 * 根据编号查询实体
	 * @param id
	 * @return
	 */
	FocusAd getFocusAdById(Long id);
	
	/**
	 * 查询单位广告列表【单位后台】
	 * @param company		所属单位（不能为NULL)
	 * @param keyword		关键词（NULL或者空不为条件）
	 * @param type			广告类型（-1不为条件）
	 * @param page			分页
	 * @return
	 */
	List<FocusAd> getFocusAdByCompany(Company company, String keyword,int type, Page page);
	
	/**
	 * 根据类型读取视频广告列表
	 * @param type	
	 * @return
	 */
	List<FocusAd> getFocusAdByType(int type);
	
	/**
	 * 查询单位幻灯片列表（带缓存）
	 * @param company
	 * @return
	 */
	List<FocusAd> getFocusAdFocusByCompany(Company company);
	/**
	 * 清除单位幻灯片列表缓存
	 * @param companyId
	 */
	void clearFocusAdFocusByCompany(Long companyId);
	
	/**
	 * 查询单位背景列表（带缓存）
	 * @param company
	 * @return
	 */
	List<FocusAd> getFocusAdBackgroundByCompany(Company company);
	/**
	 * 清除单位背景列表缓存
	 * @param companyId
	 */
	void clearFocusAdBackgroundByCompany(Long companyId);
}
