package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.CustomMenu;


/**
 * 
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 下午4:09:10
 */
@Transactional
public interface CustomMenuService {
	/**
	 * 添加菜单
	 * @param article
	 * @return
	 */
	CustomMenu addCustomMenu(CustomMenu customMenu);
	
	/**
	 * 根据ID读取
	 * @param id
	 * @return
	 */
	CustomMenu getCustomMenu(Long id);
	
	/**
	 * 根据ID读取（带缓存）
	 * @param id
	 * @return
	 */
	CustomMenu getCustomMenuById(Long id);
	
	/**
	 * 根据eventKey读取菜单（带缓存）
	 * @param eventKey
	 * @return
	 */
	CustomMenu getCustomMenuByEventKey(String eventKey);
	
	/**
	 * 更新菜单
	 * @param article
	 * @return
	 */
	CustomMenu updateCustomMenu(CustomMenu customMenu);
	
	/**
	 * 查询学校菜单
	 * @param school 	学校
	 * @param level		级别,1-一级栏目,2-二级栏目
	 * @return
	 */
	List<CustomMenu> getCustomMenuListByCompanyId(Company school,int level);



	
	
}
