package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.District;


/**
 * <b>学校</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 下午3:56:57
 */
@Transactional
public interface CompanyService {
	
	/**
	 * 创建学校
	 * @param company
	 */
	void creatCompany(Company company);
	
	/**
	 * 更新学校
	 * @param company
	 */
	void updateCompany(Company company);
	
	/**
	 * 查询学校（带缓存）
	 * @param companyId
	 * @return
	 */
	Company getCompany(Long companyId);

	/**
	 * 获取所有学校数据
	 * @return
	 */
	List<Company> getCompanyList();
	
	/**
	 * 条件查询学校表数据
	 * @param company
	 * @param province
	 * @param city
	 * @param area
	 * @param status
	 * @return
	 */
	List<Company> getCompanyListByKey(String companyName, int status, Long provinceId, Long cityId, Long areaId);
	
	/**
	 * 根据机构名称模糊查询
	 * @param companyName
	 * @return
	 */
	Company getCompanyByName(String companyName, Long provinceId, Long cityId, Long areaId);
	
	
	/**
	 * [后台管理系统]读取企业信息
	 * @param keyword		关键词(NULL不为条件,学校名称,学校别名,联系人,电话,网址 ,地址,邮编,邮箱)
	 * @param status		状态(-1不为条件,0-全部
	 * @param vertystate	审核	状态(-1不为条件,
	 * @param page			分页
	 * @return
	 */
	List<Company> getCompanyListBySystem(String keyword, int type, int subtype, int status, District province, District city,int vertystate, Page page);
}

